/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Element;

public class SymmetricKeyToken
extends SecurityTokenSPI {
    private static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$ws$SymmetricKeyToken == null ? (class$com$systinet$wasp$security$ws$SymmetricKeyToken = SymmetricKeyToken.class$("com.systinet.wasp.security.ws.SymmetricKeyToken")) : class$com$systinet$wasp$security$ws$SymmetricKeyToken).getName());
    public static final String DUMMYTAGNAME = "SymmetricKeyToken";
    private byte[] encodedKey = null;
    private String keyAlgorithm = null;
    static /* synthetic */ Class class$com$systinet$wasp$security$ws$SymmetricKeyToken;

    public SymmetricKeyToken(Element element, SecurityContext securityContext) throws XMLSecurityException {
        super(element, securityContext);
        cat.error("Symmetric Key Security Token must be external token");
        throw WSSecurityException.INVALID_SECURITY_TOKEN;
    }

    public SymmetricKeyToken(SecurityContext securityContext, boolean isExternal) {
        super(securityContext, isExternal);
    }

    public void setEncodedKey(byte[] encodedKey) {
        this.encodedKey = (byte[])(encodedKey == null ? null : (byte[])encodedKey.clone());
    }

    public byte[] getEncodedKey() {
        return this.encodedKey != null ? this.encodedKey : new byte[]{};
    }

    public void setKeyAlgorihm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm != null ? this.keyAlgorithm : "";
    }

    public void doFinal(int mode) {
        if (mode == 0 && !this.isExternal()) {
            cat.error("Symmetric Key Security Token cannot be a part of message - it must configured as an external security token");
            throw WSSecurityException.INVALID_SECURITY_TOKEN;
        }
    }

    public byte[] getKeyIdentifier() {
        return null;
    }

    public String getValueType() {
        return null;
    }

    public Key getEncryptingKey() throws WSSecurityException {
        return this.getSecretKey();
    }

    public Key getDecryptingKey() throws WSSecurityException {
        return this.getSecretKey();
    }

    public Key getSigningKey() throws WSSecurityException {
        return this.getSecretKey();
    }

    public Key getAuthenticatingKey() throws WSSecurityException {
        return this.getSecretKey();
    }

    protected SecretKey getSecretKey() throws WSSecurityException {
        return new SecretKeySpec(this.getEncodedKey(), this.getKeyAlgorithm());
    }

    public String getType() {
        return "SymmetricKey";
    }

    public String getBaseNamespace() {
        SecurityContext securityContext = this.getSecurityContext();
        if (securityContext == null) {
            securityContext = (SecurityContext)Current.getCallContext().getContextData().get(WSSecurityImpl.WSSECURITY_CONTEXT_KEY);
        }
        return securityContext.getWsseNamespace();
    }

    public String getBaseLocalName() {
        return DUMMYTAGNAME;
    }

    public SecurityTokenConf getReceivedConf() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

