/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.utils;

import java.io.ByteArrayOutputStream;
import java.util.Random;
import sun.misc.HexDumpEncoder;

public class HexDump {
    private static boolean DEBUG = false;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] BIT_DIGIT = new char[]{'0', '1'};
    private static final byte[] COMPARE_BITS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static char BYTE_SEPARATOR = (char)32;
    private static boolean WITH_BYTE_SEPARATOR = true;

    private HexDump() {
    }

    public static String prettyPrintHex(byte[] baToConvert) {
        HexDumpEncoder hde = new HexDumpEncoder();
        return hde.encodeBuffer(baToConvert);
    }

    public static String prettyPrintHex(String sToConvert) {
        return HexDump.prettyPrintHex(sToConvert.getBytes());
    }

    public static void setDebug(boolean dbg) {
        DEBUG = dbg;
    }

    public static void setWithByteSeparator(boolean bs) {
        WITH_BYTE_SEPARATOR = bs;
    }

    public static void setByteSeparator(char bs) {
        BYTE_SEPARATOR = bs;
    }

    public static void setBitDigits(char[] bd) throws Exception {
        if (bd.length != 2) {
            throw new Exception("wrong number of characters!");
        }
        BIT_DIGIT = bd;
    }

    public static void setBitDigits(char zeroBit, char oneBit) {
        HexDump.BIT_DIGIT[0] = zeroBit;
        HexDump.BIT_DIGIT[1] = oneBit;
    }

    public static String byteArrayToBinaryString(byte[] block) {
        StringBuffer strBuf = new StringBuffer();
        int iLen = block.length;
        int i = 0;
        while (i < iLen) {
            HexDump.byte2bin(block[i], strBuf);
            if (i < iLen - 1 & WITH_BYTE_SEPARATOR) {
                strBuf.append(BYTE_SEPARATOR);
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static String toBinaryString(byte[] ba) {
        return HexDump.byteArrayToBinaryString(ba);
    }

    public static String toBinaryString(byte b) {
        byte[] ba = new byte[]{b};
        return HexDump.byteArrayToBinaryString(ba);
    }

    public static String toBinaryString(short s) {
        return HexDump.toBinaryString(HexDump.toByteArray(s));
    }

    public static String toBinaryString(int i) {
        return HexDump.toBinaryString(HexDump.toByteArray(i));
    }

    public static String toBinaryString(long l) {
        return HexDump.toBinaryString(HexDump.toByteArray(l));
    }

    public static final byte[] toByteArray(short s) {
        byte[] baTemp = new byte[2];
        baTemp[1] = (byte)s;
        baTemp[0] = (byte)(s >> 8);
        return baTemp;
    }

    public static final byte[] toByteArray(int i) {
        byte[] baTemp = new byte[4];
        baTemp[3] = (byte)i;
        baTemp[2] = (byte)(i >> 8);
        baTemp[1] = (byte)(i >> 16);
        baTemp[0] = (byte)(i >> 24);
        return baTemp;
    }

    public static final byte[] toByteArray(long l) {
        byte[] baTemp = new byte[8];
        baTemp[7] = (byte)l;
        baTemp[6] = (byte)(l >> 8);
        baTemp[5] = (byte)(l >> 16);
        baTemp[4] = (byte)(l >> 24);
        baTemp[3] = (byte)(l >> 32);
        baTemp[2] = (byte)(l >> 40);
        baTemp[1] = (byte)(l >> 48);
        baTemp[0] = (byte)(l >> 56);
        return baTemp;
    }

    public static String byteArrayToHexString(byte[] block) {
        long lTime = System.currentTimeMillis();
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        int i = 0;
        while (i < len) {
            HexDump.byte2hex(block[i], buf);
            if (i < len - 1 & WITH_BYTE_SEPARATOR) {
                buf.append(BYTE_SEPARATOR);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String stringToHexString(String in) {
        byte[] ba = in.getBytes();
        return HexDump.toHexString(ba);
    }

    public static String byteArrayToHexString(byte[] block, int offset, int length) {
        long lTime = System.currentTimeMillis();
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        if (len < (length += offset)) {
            length = len;
        }
        int i = 0 + offset;
        while (i < length) {
            HexDump.byte2hex(block[i], buf);
            if (i < length - 1) {
                buf.append(":");
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toHexString(byte[] ba) {
        return HexDump.toHexString(ba, 0, ba.length);
    }

    public static String toHexString(byte b) {
        byte[] ba = new byte[]{b};
        return HexDump.toHexString(ba, 0, ba.length);
    }

    public static String toHexString(short s) {
        return HexDump.toHexString(HexDump.toByteArray(s));
    }

    public static String toHexString(int i) {
        return HexDump.toHexString(HexDump.toByteArray(i));
    }

    public static String toHexString(long l) {
        return HexDump.toHexString(HexDump.toByteArray(l));
    }

    public static String toString(byte[] ba) {
        return new String(ba).toString();
    }

    public static String toString(byte b) {
        byte[] ba = new byte[]{b};
        return new String(ba).toString();
    }

    public static String toHexString(byte[] ba, int offset, int length) {
        long lTime = System.currentTimeMillis();
        char[] buf = WITH_BYTE_SEPARATOR ? new char[length * 3] : new char[length * 2];
        int i = offset;
        int j = 0;
        while (i < offset + length) {
            byte k = ba[i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
            if (!WITH_BYTE_SEPARATOR) continue;
            buf[j++] = BYTE_SEPARATOR;
        }
        return new String(buf);
    }

    public static byte[] hexStringToByteArray(String strA) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int sum = 0;
        boolean nextCharIsUpper = true;
        int i = 0;
        while (i < strA.length()) {
            char c = strA.charAt(i);
            switch (Character.toUpperCase(c)) {
                case '0': {
                    if (nextCharIsUpper) {
                        sum = 0;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 0);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case '1': {
                    if (nextCharIsUpper) {
                        sum = 16;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 1);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case '2': {
                    if (nextCharIsUpper) {
                        sum = 32;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 2);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case '3': {
                    if (nextCharIsUpper) {
                        sum = 48;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 3);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case '4': {
                    if (nextCharIsUpper) {
                        sum = 64;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 4);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case '5': {
                    if (nextCharIsUpper) {
                        sum = 80;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 5);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case '6': {
                    if (nextCharIsUpper) {
                        sum = 96;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 6);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case '7': {
                    if (nextCharIsUpper) {
                        sum = 112;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 7);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case '8': {
                    if (nextCharIsUpper) {
                        sum = -128;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 8);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case '9': {
                    if (nextCharIsUpper) {
                        sum = -112;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 9);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case 'A': {
                    if (nextCharIsUpper) {
                        sum = -96;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 0xA);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case 'B': {
                    if (nextCharIsUpper) {
                        sum = -80;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 0xB);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case 'C': {
                    if (nextCharIsUpper) {
                        sum = -64;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 0xC);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case 'D': {
                    if (nextCharIsUpper) {
                        sum = -48;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 0xD);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case 'E': {
                    if (nextCharIsUpper) {
                        sum = -32;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 0xE);
                    result.write(sum);
                    nextCharIsUpper = true;
                    break;
                }
                case 'F': {
                    if (nextCharIsUpper) {
                        sum = -16;
                        nextCharIsUpper = false;
                        break;
                    }
                    sum = (byte)(sum | 0xF);
                    result.write(sum);
                    nextCharIsUpper = true;
                }
            }
            ++i;
        }
        if (!nextCharIsUpper) {
            throw new RuntimeException("The String did not contain an equal number of hex digits");
        }
        return result.toByteArray();
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static void byte2bin(byte b, StringBuffer buf) {
        int i = 0;
        while (i < 8) {
            if ((b & COMPARE_BITS[i]) != 0) {
                buf.append(BIT_DIGIT[1]);
            } else {
                buf.append(BIT_DIGIT[0]);
            }
            ++i;
        }
    }

    private static String intToHexString(int n) {
        char[] buf = new char[8];
        int i = 7;
        while (i >= 0) {
            buf[i] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --i;
        }
        return new String(buf);
    }

    public static void main(String[] args) {
        System.out.println("-test and demo of the converter ");
        HexDump.setDebug(false);
        String str = new String("Niko");
        byte[] ba = str.getBytes();
        System.out.println("to convert: " + str);
        System.out.println("converted1: " + HexDump.byteArrayToHexString(ba));
        System.out.println("converted1: " + HexDump.byteArrayToHexString(ba, 0, ba.length));
        System.out.println("converted3: " + HexDump.stringToHexString(str));
        System.out.println("----Convert integer to hexString...");
        int i = -2;
        System.out.println("to convert: " + i + " -> " + HexDump.intToHexString(i));
        System.out.println("----Convert byte[] to binary String...");
        byte[] baToConvert = new byte[]{-1, 0, 51, 17, -1, 95, 95, 79, 31, -1};
        System.out.println("to convert: " + HexDump.toHexString(baToConvert) + " -> " + HexDump.byteArrayToBinaryString(baToConvert));
        HexDump.setByteSeparator('-');
        System.out.println("to convert: " + HexDump.toHexString(baToConvert) + " -> " + HexDump.byteArrayToBinaryString(baToConvert));
        HexDump.setByteSeparator('*');
        HexDump.setWithByteSeparator(true);
        System.out.println("to convert: " + HexDump.toHexString(baToConvert) + " -> " + HexDump.byteArrayToBinaryString(baToConvert));
        char[] bd = new char[]{'a', 'b'};
        try {
            HexDump.setBitDigits(bd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("to convert: " + HexDump.toHexString(baToConvert) + " -> " + HexDump.byteArrayToBinaryString(baToConvert));
        HexDump.setBitDigits('0', '1');
        System.out.println("---- Convert.toByteArray(int) ");
        int iToConvert = -10;
        while (iToConvert < 10) {
            System.out.println("to convert = " + iToConvert + " = " + HexDump.toBinaryString(iToConvert));
            byte[] baConvInt = new byte[4];
            baConvInt = HexDump.toByteArray(iToConvert);
            System.out.println("convertet byteArray = " + HexDump.toBinaryString(baConvInt));
            ++iToConvert;
        }
        System.out.println("---- toHexString(int) ");
        i = -1;
        System.out.println(i + " = 0x" + HexDump.toHexString(i) + " = " + HexDump.toBinaryString(i));
        System.out.println(++i + " = 0x" + HexDump.toHexString(i) + " = " + HexDump.toBinaryString(i));
        System.out.println("---- toHexString(long) ");
        long l = 100L;
        System.out.println(l + " = 0x" + HexDump.toHexString(l) + " = " + HexDump.toBinaryString(l));
        Random rnd = new Random();
        l = rnd.nextLong();
        System.out.println(l + " = 0x" + HexDump.toHexString(l) + " = " + HexDump.toBinaryString(l));
        System.out.println("---- toHexString(short) ");
        short s = 100;
        System.out.println(s + " = 0x" + HexDump.toHexString(s) + " = " + HexDump.toBinaryString(s));
        rnd = new Random();
        s = (short)rnd.nextInt();
        System.out.println(s + " = 0x" + HexDump.toHexString(s) + " = " + HexDump.toBinaryString(s));
        System.out.println("---- read file in Hex-Format ");
        String strToConvert = "12345654321";
        System.out.println(strToConvert + " = " + HexDump.stringToHexString(strToConvert));
        System.out.println("Das ist die Hex-Darstellung des obigen Strings");
        byte[] baConverted = new byte[strToConvert.length()];
        baConverted = HexDump.hexStringToByteArray(strToConvert);
        System.out.println("ba = " + HexDump.toHexString(ba));
    }
}

