/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.utils;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.HelperNodeList;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ElementProxy {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$utils$ElementProxy == null ? (class$com$systinet$wasp$security$secext$utils$ElementProxy = ElementProxy.class$("com.systinet.wasp.security.secext.utils.ElementProxy")) : class$com$systinet$wasp$security$secext$utils$ElementProxy).getName());
    public static final int MODE_CREATE = 0;
    public static final int MODE_PROCESS = 1;
    public static final int MODE_UNKNOWN = 2;
    public static final int MODE_SIGN = 0;
    public static final int MODE_VERIFY = 1;
    public static final int MODE_ENCRYPT = 0;
    public static final int MODE_DECRYPT = 1;
    protected int _state = 2;
    protected Element _constructionElement = null;
    protected String _baseURI = null;
    protected Document _doc = null;
    protected SecurityTokenSPI parent;
    static HashMap _prefixMappings = new HashMap();
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$utils$ElementProxy;

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    public ElementProxy() {
    }

    public ElementProxy(Document doc) {
        this((SecurityTokenSPI)null, doc);
    }

    public ElementProxy(SecurityTokenSPI parent, Document doc) {
        this();
        this.parent = parent;
        if (doc == null) {
            throw new RuntimeException("Document is null");
        }
        this._doc = doc;
        this._state = 0;
        this._constructionElement = ElementProxy.createElementForFamily(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
    }

    public static Element createElementForFamily(Document doc, String namespace, String localName) {
        Element result = null;
        String prefix = ElementProxy.getDefaultPrefix(namespace);
        if (namespace == null) {
            result = doc.createElementNS(null, localName);
        } else if (prefix == null || prefix.length() == 0) {
            result = doc.createElementNS(namespace, localName);
            result.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespace);
        } else {
            result = doc.createElementNS(namespace, prefix + ":" + localName);
            result.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        }
        return result;
    }

    public void setElement(Element element, String BaseURI) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = BaseURI;
    }

    public ElementProxy(Element element, String BaseURI) throws XMLSecurityException {
        this(null, element, BaseURI);
    }

    public ElementProxy(SecurityTokenSPI parent, Element element, String BaseURI) throws XMLSecurityException {
        this();
        this.parent = parent;
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = BaseURI;
        this.guaranteeThatElementInCorrectSpace();
    }

    public final Element getElement() {
        return this._constructionElement;
    }

    public final NodeList getElementPlusReturns() {
        HelperNodeList nl = new HelperNodeList();
        nl.appendChild(this._doc.createTextNode("\n"));
        nl.appendChild(this.getElement());
        nl.appendChild(this._doc.createTextNode("\n"));
        return nl;
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getBaseURI() {
        return this._baseURI;
    }

    public void guaranteeThatElementInCorrectSpace() throws XMLSecurityException {
        String localnameSHOULDBE = this.getBaseLocalName();
        String namespaceSHOULDBE = this.getBaseNamespace();
        String qnameSHOULDBE = "{" + (namespaceSHOULDBE == null ? "" : namespaceSHOULDBE) + "}" + localnameSHOULDBE;
        String localnameIS = this._constructionElement.getLocalName();
        String namespaceIS = this._constructionElement.getNamespaceURI();
        String qnameIS = "{" + (namespaceIS == null ? "" : namespaceIS) + "}" + localnameIS;
        if (!qnameIS.equals(qnameSHOULDBE)) {
            Object[] exArgs = new Object[]{qnameSHOULDBE, qnameIS};
            throw new XMLSecurityException("xml.WrongElement", exArgs);
        }
    }

    public void addBigIntegerElement(BigInteger bi, String localname) {
        if (bi != null) {
            Element e = XMLUtils.createElementInSignatureSpace(this._doc, localname);
            Base64.fillElementWithBigInteger(e, bi);
            this._constructionElement.appendChild(e);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addBase64Element(byte[] bytes, String localname) {
        if (bytes != null) {
            Element e = Base64.encodeToElement(this._doc, localname, bytes);
            this._constructionElement.appendChild(e);
            this._constructionElement.appendChild(this._doc.createTextNode("\n"));
        }
    }

    public void addTextElement(String text, String localname) {
        Element e = XMLUtils.createElementInSignatureSpace(this._doc, localname);
        Text t = this._doc.createTextNode(text);
        e.appendChild(t);
        this._constructionElement.appendChild(e);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addBase64Text(byte[] bytes) {
        if (bytes != null) {
            Text t = this._doc.createTextNode(Base64.encode(bytes, -1));
            this._constructionElement.appendChild(t);
        }
    }

    public void addText(String text) {
        if (text != null) {
            Text t = this._doc.createTextNode(text);
            this._constructionElement.appendChild(t);
        }
    }

    public BigInteger getBigIntegerFromChildElement(String localname, String namespace) throws XMLSecurityException {
        try {
            Element nscontext = XMLUtils.createDSctx(this._doc, "x", namespace);
            Text t = (Text)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)("./x:" + localname + "/text()"), (Node)nscontext);
            return Base64.decodeBigIntegerFromText(t);
        }
        catch (TransformerException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] getBytesFromChildElement(String localname, String namespace) throws XMLSecurityException {
        try {
            Element nscontext = XMLUtils.createDSctx(this._doc, "x", namespace);
            Element e = (Element)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)("./x:" + localname), (Node)nscontext);
            return Base64.decode(e);
        }
        catch (TransformerException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public String getTextFromChildElement(String localname, String namespace) throws XMLSecurityException {
        try {
            Element nscontext = XMLUtils.createDSctx(this._doc, "x", namespace);
            Text t = (Text)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)("./x:" + localname + "/text()"), (Node)nscontext);
            return t.getData();
        }
        catch (TransformerException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] getBytesFromTextChild() throws XMLSecurityException {
        try {
            Text t = (Text)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)"./text()");
            return Base64.decode(t.getData());
        }
        catch (TransformerException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public String getTextFromTextChild() {
        return XMLUtils.getFullTextChildrenFromElement(this._constructionElement);
    }

    public Element getChildElementLocalName(int index, String namespace, String localname) {
        NodeList childNodes = this._constructionElement.getChildNodes();
        int maxLength = childNodes.getLength();
        int result = -1;
        int i = 0;
        while (i < maxLength) {
            Node n = childNodes.item(i);
            if (n.getNodeType() == 1) {
                String ns = n.getNamespaceURI();
                String name = n.getLocalName();
                if ((namespace != null && ns != null && namespace.equals(ns) || namespace == null && ns == null) && localname.equals(name) && ++result == index) {
                    return (Element)n;
                }
            }
            ++i;
        }
        return null;
    }

    public int length(String namespace, String localname) {
        NodeList childNodes = this._constructionElement.getChildNodes();
        int maxLength = childNodes.getLength();
        int result = 0;
        int i = 0;
        while (i < maxLength) {
            Node n = childNodes.item(i);
            if (n.getNodeType() == 1) {
                String ns = n.getNamespaceURI();
                String name = n.getLocalName();
                if ((namespace != null && ns != null && namespace.equals(ns) || namespace == null && ns == null) && localname.equals(name)) {
                    ++result;
                }
            }
            ++i;
        }
        return result;
    }

    public void setXPathNamespaceContext(String prefix, String uri) throws XMLSecurityException {
        String ns = prefix == null || prefix.length() == 0 ? "xmlns" : (prefix.equals("xmlns") ? "xmlns" : (prefix.startsWith("xmlns:") ? "xmlns:" + prefix.substring("xmlns:".length()) : "xmlns:" + prefix));
        if (ns.equals("xmlns")) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        Attr a = this._constructionElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", ns);
        if (a != null && !a.getNodeValue().equals(uri)) {
            Object[] exArgs = new Object[]{ns, this._constructionElement.getAttributeNS(null, ns)};
            throw new XMLSecurityException("namespacePrefixAlreadyUsedByOtherURI", exArgs);
        }
        this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", ns, uri);
    }

    public static void setDefaultPrefix(String namespace, String prefix) throws XMLSecurityException {
        Iterator keys = _prefixMappings.keySet().iterator();
        while (keys.hasNext()) {
            String storedNamespace = (String)keys.next();
            String storedPrefix = (String)_prefixMappings.get(storedNamespace);
        }
        _prefixMappings.put(namespace, prefix);
    }

    public static String getDefaultPrefix(String namespace) {
        String prefix = (String)_prefixMappings.get(namespace);
        return prefix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

