/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms.implementations;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.c14n.implementations.Canonicalizer20010315OmitComments;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.TransformSpi;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TransformC14N
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";

    public boolean wantsOctetStream() {
        return true;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException, ParserConfigurationException, SAXException {
        try {
            Canonicalizer20010315OmitComments c14n = new Canonicalizer20010315OmitComments();
            byte[] result = null;
            result = input.isOctetStream() ? c14n.engineCanonicalize(input.getBytes()) : c14n.engineCanonicalizeXPathNodeSet(input.getNodeSet());
            return new XMLSignatureInput(result);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            CanonicalizationException cex = new CanonicalizationException("c14n.Canonicalizer.ParserConfigurationException", exArgs);
            throw cex;
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{ex.toString()};
            CanonicalizationException cex = new CanonicalizationException("c14n.Canonicalizer.SAXException", exArgs);
            throw cex;
        }
    }
}

