/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms.implementations;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.Base64DecodingException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.TransformSpi;
import com.systinet.wasp.security.secext.transforms.TransformationException;
import com.systinet.wasp.security.secext.utils.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class TransformBase64Decode
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#base64";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    public boolean wantsOctetStream() {
        return true;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, TransformationException, InvalidCanonicalizerException {
        if (input.isOctetStream()) {
            try {
                byte[] base64Bytes = input.getBytes();
                byte[] decodedBytes = Base64.decode(base64Bytes);
                return new XMLSignatureInput(new ByteArrayInputStream(decodedBytes));
            }
            catch (Base64DecodingException ex) {
                throw new TransformationException("empty", ex);
            }
        }
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input.getOctetStream());
            DocumentTraversal dt = (DocumentTraversal)((Object)doc);
            Document rootNode = doc;
            AlwaysAcceptNodeFilter nodefilter = new AlwaysAcceptNodeFilter();
            TreeWalker treewalker = dt.createTreeWalker(rootNode, -1, nodefilter, true);
            StringBuffer sb = new StringBuffer();
            this.process(treewalker, sb);
            byte[] decodedBytes = Base64.decode(sb.toString());
            return new XMLSignatureInput(new ByteArrayInputStream(decodedBytes));
        }
        catch (ParserConfigurationException e) {
            throw new TransformationException("c14n.Canonicalizer.Exception", e);
        }
        catch (SAXException e) {
            throw new TransformationException("c14n.Canonicalizer.Exception", e);
        }
        catch (Base64DecodingException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    private void process(TreeWalker treewalker, StringBuffer sb) {
        Node currentNode = treewalker.getCurrentNode();
        if (currentNode.getNodeType() == 3) {
            sb.append(((Text)currentNode).getData());
        }
        Node node1 = treewalker.firstChild();
        while (node1 != null) {
            this.process(treewalker, sb);
            node1 = treewalker.nextSibling();
        }
        treewalker.setCurrentNode(currentNode);
    }

    public class AlwaysAcceptNodeFilter
    implements NodeFilter {
        public short acceptNode(Node n) {
            return 1;
        }
    }
}

