/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.AlgorithmAlreadyRegisteredException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.InvalidTransformException;
import com.systinet.wasp.security.secext.transforms.TransformSpi;
import com.systinet.wasp.security.secext.transforms.TransformationException;
import com.systinet.wasp.security.secext.utils.HelperNodeList;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import com.systinet.wasp.security.ws.impl.TransformSTR;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$transforms$Transform == null ? (class$com$systinet$wasp$security$secext$transforms$Transform = Transform.class$("com.systinet.wasp.security.secext.transforms.Transform")) : class$com$systinet$wasp$security$secext$transforms$Transform).getName());
    static boolean _alreadyInitialized = false;
    static HashMap _transformHash = null;
    protected TransformSpi transformSpi = null;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$transforms$Transform;

    public Transform(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        super(doc);
        try {
            this._constructionElement.setAttributeNS(null, "Algorithm", algorithmURI);
            String implementingClass = Transform.getImplementingClass(algorithmURI);
            this.transformSpi = (TransformSpi)Class.forName(implementingClass).newInstance();
            this.transformSpi.setTransform(this);
            if (contextNodes != null) {
                int i = 0;
                while (i < contextNodes.getLength()) {
                    this._constructionElement.appendChild(contextNodes.item(i).cloneNode(true));
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
        catch (InstantiationException ex) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
    }

    public Transform(Element element, String BaseURI) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, BaseURI);
        String AlgorithmURI = element.getAttributeNS(null, "Algorithm");
        if (AlgorithmURI == null || AlgorithmURI.length() == 0) {
            Object[] exArgs = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", exArgs);
        }
        try {
            String implementingClass = (String)_transformHash.get(AlgorithmURI);
            if (implementingClass == null) {
                Object[] exArgs = new Object[]{AlgorithmURI};
                throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
            }
            this.transformSpi = (TransformSpi)Class.forName(implementingClass).newInstance();
            this.transformSpi.setTransform(this);
        }
        catch (ClassNotFoundException e) {
            Object[] exArgs = new Object[]{AlgorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
        catch (IllegalAccessException e) {
            Object[] exArgs = new Object[]{AlgorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
        catch (InstantiationException e) {
            Object[] exArgs = new Object[]{AlgorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
    }

    public static final Transform getInstance(Document doc, String algorithmURI) throws InvalidTransformException {
        return Transform.getInstance(doc, algorithmURI, (NodeList)null);
    }

    public static final Transform getInstance(Document doc, String algorithmURI, Element contextChild) throws InvalidTransformException {
        HelperNodeList contextNodes = new HelperNodeList();
        contextNodes.appendChild(doc.createTextNode("\n"));
        contextNodes.appendChild(contextChild);
        contextNodes.appendChild(doc.createTextNode("\n"));
        return Transform.getInstance(doc, algorithmURI, contextNodes);
    }

    public static final Transform getInstance(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        return new Transform(doc, algorithmURI, contextNodes);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _transformHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException {
        String registeredClass = Transform.getImplementingClass(algorithmURI);
        if (registeredClass != null && registeredClass.length() != 0) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        _transformHash.put(algorithmURI, implementingClass);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput result = null;
        try {
            result = this.transformSpi.enginePerformTransform(input);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        return result;
    }

    private static String getImplementingClass(String URI2) {
        try {
            Iterator i = _transformHash.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!key.equals(URI2)) continue;
                return (String)_transformHash.get(key);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public String getBaseLocalName() {
        return "Transform";
    }

    public void clean() {
        if (this.transformSpi != null && this.transformSpi instanceof TransformSTR) {
            ((TransformSTR)this.transformSpi).clean();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

