/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.signature;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.MissingResourceFailureException;
import com.systinet.wasp.security.secext.signature.Reference;
import com.systinet.wasp.security.secext.signature.ReferenceNotInitializedException;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.Transforms;
import com.systinet.wasp.security.secext.utils.I18n;
import com.systinet.wasp.security.secext.utils.IdResolver;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import com.systinet.wasp.security.secext.utils.resolver.ResourceResolver;
import com.systinet.wasp.security.secext.utils.resolver.ResourceResolverSpi;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Manifest
extends SignatureElementProxy {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$signature$Manifest == null ? (class$com$systinet$wasp$security$secext$signature$Manifest = Manifest.class$("com.systinet.wasp.security.secext.signature.Manifest")) : class$com$systinet$wasp$security$secext$signature$Manifest).getName());
    Vector _references;
    private boolean[] verificationResults = null;
    Vector _signedContents = new Vector();
    HashMap _resolverProperties = new HashMap(10);
    Vector _perManifestResolvers = new Vector();
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$signature$Manifest;

    public Manifest(Document doc) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._references = new Vector();
    }

    public Manifest(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        int le = this.length("http://www.w3.org/2000/09/xmldsig#", "Reference");
        if (le == 0) {
            Object[] exArgs = new Object[]{"Reference", "Manifest"};
            throw new DOMException(4, I18n.translate("xml.WrongContent", exArgs));
        }
        this._references = new Vector(le);
        int i = 0;
        while (i < le) {
            this._references.add(null);
            ++i;
        }
    }

    public void addDocument(String BaseURI, String referenceURI, Transforms transforms, String digestURI, String ReferenceId, String ReferenceType) throws XMLSignatureException {
        if (this._state == 0) {
            Reference ref = new Reference(this._doc, BaseURI, referenceURI, this, transforms, digestURI);
            if (ReferenceId != null) {
                ref.setId(ReferenceId);
            }
            if (ReferenceType != null) {
                ref.setType(ReferenceType);
            }
            this._references.add(ref);
            this._constructionElement.appendChild(ref.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void generateDigestValues() throws XMLSignatureException, ReferenceNotInitializedException {
        if (this._state == 0) {
            int i = 0;
            while (i < this.getLength()) {
                Reference currentRef = (Reference)this._references.elementAt(i);
                currentRef.generateDigestValue();
                ++i;
            }
        }
    }

    public int getLength() {
        return this._references.size();
    }

    public Reference item(int i) throws XMLSecurityException {
        if (this._state == 0) {
            return (Reference)this._references.elementAt(i);
        }
        if (this._references.elementAt(i) == null) {
            Element refElem = super.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "Reference");
            Reference ref = new Reference(refElem, this._baseURI, this);
            this._references.set(i, ref);
        }
        return (Reference)this._references.elementAt(i);
    }

    public void setId(String Id) {
        if (this._state == 0 && Id != null) {
            this._constructionElement.setAttributeNS(null, "Id", Id);
            IdResolver.registerElementById(this._constructionElement, Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public boolean verifyReferences() throws MissingResourceFailureException, XMLSecurityException {
        return this.verifyReferences(false);
    }

    public boolean verifyReferences(boolean followManifests) throws MissingResourceFailureException, XMLSecurityException {
        boolean verify = true;
        if (this.length("http://www.w3.org/2000/09/xmldsig#", "Reference") == 0) {
            throw new XMLSecurityException("empty", new Object[]{"Signature has not any reference"});
        }
        this.verificationResults = new boolean[this.length("http://www.w3.org/2000/09/xmldsig#", "Reference")];
        int i = 0;
        while (i < this.length("http://www.w3.org/2000/09/xmldsig#", "Reference")) {
            block14: {
                Reference currentRef = new Reference(this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "Reference"), this._baseURI, this);
                this._references.set(i, currentRef);
                try {
                    boolean currentRefVerified = currentRef.verify();
                    this.setVerificationResult(i, currentRefVerified);
                    if (!currentRefVerified) {
                        verify = false;
                    }
                    if (!verify || !followManifests || !currentRef.typeIsReferenceToManifest()) break block14;
                    try {
                        currentRef.dereferenceURIandPerformTransforms();
                        XMLSignatureInput signedManifestNodes = currentRef.getTransformsOutput();
                        Set nl = signedManifestNodes.getNodeSet();
                        Manifest referencedManifest = null;
                        Iterator nlIterator = nl.iterator();
                        while (nlIterator.hasNext()) {
                            Node n = (Node)nlIterator.next();
                            if (n.getNodeType() != 1 || !((Element)n).getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || !((Element)n).getLocalName().equals("Manifest")) continue;
                            try {
                                referencedManifest = new Manifest((Element)n, signedManifestNodes.getSourceURI());
                                break;
                            }
                            catch (XMLSecurityException ex) {
                                // empty catch block
                            }
                        }
                        if (referencedManifest == null) {
                            throw new MissingResourceFailureException("empty", currentRef);
                        }
                        referencedManifest._perManifestResolvers = this._perManifestResolvers;
                        referencedManifest._resolverProperties = this._resolverProperties;
                        boolean referencedManifestValid = referencedManifest.verifyReferences(followManifests);
                        if (!referencedManifestValid) {
                            verify = false;
                            cat.warn("The nested Manifest was invalid (bad)");
                        }
                    }
                    catch (IOException ex) {
                        throw new ReferenceNotInitializedException("empty", ex);
                    }
                    catch (ParserConfigurationException ex) {
                        throw new ReferenceNotInitializedException("empty", ex);
                    }
                    catch (SAXException ex) {
                        throw new ReferenceNotInitializedException("empty", ex);
                    }
                }
                catch (ReferenceNotInitializedException ex) {
                    Object[] exArgs = new Object[]{currentRef.getURI()};
                    throw new MissingResourceFailureException("signature.Verification.Reference.NoInput", exArgs, ex, currentRef);
                }
            }
            ++i;
        }
        return verify;
    }

    private void setVerificationResult(int index, boolean verify) throws XMLSecurityException {
        if (this.verificationResults == null) {
            this.verificationResults = new boolean[this.getLength()];
        }
        this.verificationResults[index] = verify;
    }

    public boolean getVerificationResult(int index) throws XMLSecurityException {
        if (index < 0 || index > this.getLength() - 1) {
            Object[] exArgs = new Object[]{Integer.toString(index), Integer.toString(this.getLength())};
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(I18n.translate("signature.Verification.IndexOutOfBounds", exArgs));
            throw new XMLSecurityException("generic.EmptyMessage", e);
        }
        if (this.verificationResults == null) {
            try {
                boolean discard = this.verifyReferences();
            }
            catch (Exception ex) {
                throw new XMLSecurityException("generic.EmptyMessage", ex);
            }
        }
        return this.verificationResults[index];
    }

    public void addResourceResolver(ResourceResolver resolver) {
        if (resolver != null) {
            this._perManifestResolvers.add(resolver);
        }
    }

    public void addResourceResolver(ResourceResolverSpi resolverSpi) {
        if (resolverSpi != null) {
            this._perManifestResolvers.add(new ResourceResolver(resolverSpi));
        }
    }

    public void setResolverProperty(String key, String value) {
        Iterator i = this._resolverProperties.keySet().iterator();
        while (i.hasNext()) {
            String c = (String)i.next();
            if (!c.equals(key)) continue;
            key = c;
            break;
        }
        this._resolverProperties.put(key, value);
    }

    public String getResolverProperty(String key) {
        Iterator i = this._resolverProperties.keySet().iterator();
        while (i.hasNext()) {
            String c = (String)i.next();
            if (!c.equals(key)) continue;
            key = c;
            break;
        }
        return (String)this._resolverProperties.get(key);
    }

    public byte[] getSignedContentItem(int i) throws XMLSignatureException {
        try {
            return this.getReferencedContentAfterTransformsItem(i).getBytes();
        }
        catch (IOException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public XMLSignatureInput getReferencedContentBeforeTransformsItem(int i) throws XMLSecurityException {
        return this.item(i).getContentsBeforeTransformation();
    }

    public XMLSignatureInput getReferencedContentAfterTransformsItem(int i) throws XMLSecurityException {
        return this.item(i).getContentsAfterTransformation();
    }

    public int getSignedContentLength() {
        return this.getLength();
    }

    public String getBaseLocalName() {
        return "Manifest";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

