/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.keyresolver.implementations;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.x509.XMLX509SubjectName;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverException;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverSpi;
import com.systinet.wasp.security.secext.keys.storage.StorageResolver;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509SubjectNameResolver == null ? (class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509SubjectNameResolver = X509SubjectNameResolver.class$("com.systinet.wasp.security.secext.keys.keyresolver.implementations.X509SubjectNameResolver")) : class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509SubjectNameResolver).getName());
    private NodeList _x509childNodes = null;
    private XMLX509SubjectName[] _x509childObject = null;
    private int _currentNode = 0;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509SubjectNameResolver;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        try {
            XMLUtils.guaranteeThatElementInSignatureSpace(element, "X509Data");
        }
        catch (XMLSignatureException ex) {
            return false;
        }
        try {
            Element nscontext = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
            this._x509childNodes = XPathAPI.selectNodeList((Node)element, (String)"./ds:X509SubjectName", (Node)nscontext);
            if (this._x509childNodes != null && this._x509childNodes.getLength() > 0) {
                return true;
            }
        }
        catch (TransformerException ex) {
            // empty catch block
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            boolean weCanResolve;
            if (!(this._x509childNodes != null || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._x509childNodes != null)) {
                return null;
            }
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509SubjectName"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                cat.info("", (Throwable)ex);
                throw ex;
            }
            this._x509childObject = new XMLX509SubjectName[this._x509childNodes.getLength()];
            int i = 0;
            while (i < this._x509childNodes.getLength()) {
                this._x509childObject[i] = new XMLX509SubjectName((Element)this._x509childNodes.item(i), BaseURI);
                ++i;
            }
            while (storage.hasNext()) {
                X509Certificate cert = storage.next();
                XMLX509SubjectName certSN = new XMLX509SubjectName(element.getOwnerDocument(), cert);
                int i2 = 0;
                while (i2 < this._x509childObject.length) {
                    if (certSN.equals(this._x509childObject[i2])) {
                        return cert;
                    }
                    ++i2;
                }
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

