/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.keyresolver.implementations;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.x509.XMLX509Certificate;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverException;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverSpi;
import com.systinet.wasp.security.secext.keys.storage.StorageResolver;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class X509CertificateResolver
extends KeyResolverSpi {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509CertificateResolver == null ? (class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509CertificateResolver = X509CertificateResolver.class$("com.systinet.wasp.security.secext.keys.keyresolver.implementations.X509CertificateResolver")) : class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509CertificateResolver).getName());
    NodeList _x509CertKeyElements = null;
    XMLX509Certificate[] _x509certObject = null;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509CertificateResolver;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        try {
            XMLUtils.guaranteeThatElementInSignatureSpace(element, "X509Data");
        }
        catch (XMLSignatureException ex) {
            return false;
        }
        try {
            Element nscontext = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
            this._x509CertKeyElements = XPathAPI.selectNodeList((Node)element, (String)"./ds:X509Certificate", (Node)nscontext);
            if (this._x509CertKeyElements != null && this._x509CertKeyElements.getLength() > 0) {
                return true;
            }
        }
        catch (TransformerException ex) {
            // empty catch block
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            boolean weCanResolve;
            if (!(this._x509CertKeyElements != null && this._x509CertKeyElements.getLength() != 0 || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._x509CertKeyElements != null && this._x509CertKeyElements.getLength() != 0)) {
                return null;
            }
            this._x509certObject = new XMLX509Certificate[this._x509CertKeyElements.getLength()];
            int i = 0;
            while (i < this._x509CertKeyElements.getLength()) {
                this._x509certObject[i] = new XMLX509Certificate((Element)this._x509CertKeyElements.item(i), BaseURI);
                ++i;
            }
            int i2 = 0;
            while (i2 < this._x509certObject.length) {
                X509Certificate cert = this._x509certObject[i2].getX509Certificate();
                if (cert != null) {
                    return cert;
                }
                ++i2;
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

