/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.keyresolver.implementations;

import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.keyvalues.DSAKeyValue;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverException;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverSpi;
import com.systinet.wasp.security.secext.keys.storage.StorageResolver;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DSAKeyValueResolver
extends KeyResolverSpi {
    private Element _dsaKeyElement = null;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        if (element == null) {
            return false;
        }
        boolean isKeyValue = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        boolean isDSAKeyValue = XMLUtils.elementIsInSignatureSpace(element, "DSAKeyValue");
        if (isKeyValue) {
            try {
                Element nscontext = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
                this._dsaKeyElement = (Element)XPathAPI.selectSingleNode((Node)element, (String)"./ds:DSAKeyValue", (Node)nscontext);
                if (this._dsaKeyElement != null) {
                    return true;
                }
            }
            catch (TransformerException ex) {}
        } else if (isDSAKeyValue) {
            this._dsaKeyElement = element;
            return true;
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        boolean weCanResolve;
        if (!(this._dsaKeyElement != null || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._dsaKeyElement != null)) {
            return null;
        }
        try {
            DSAKeyValue dsaKeyValue = new DSAKeyValue(this._dsaKeyElement, BaseURI);
            PublicKey pk = dsaKeyValue.getPublicKey();
            return pk;
        }
        catch (XMLSecurityException ex) {
            return null;
        }
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return null;
    }
}

