/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.content.x509;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.x509.XMLX509DataContent;
import com.systinet.wasp.security.secext.utils.JavaUtils;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509Certificate
extends SignatureElementProxy
implements XMLX509DataContent {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509Certificate == null ? (class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509Certificate = XMLX509Certificate.class$("com.systinet.wasp.security.secext.keys.content.x509.XMLX509Certificate")) : class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509Certificate).getName());
    public static final String JCA_CERT_ID = "X.509";
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509Certificate;

    public XMLX509Certificate(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public XMLX509Certificate(Document doc, byte[] certificateBytes) {
        super(doc);
        this.addBase64Text(certificateBytes);
    }

    public XMLX509Certificate(Document doc, X509Certificate x509certificate) throws XMLSecurityException {
        super(doc);
        try {
            this.addBase64Text(x509certificate.getEncoded());
        }
        catch (CertificateEncodingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] getCertificateBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public X509Certificate getX509Certificate() throws XMLSecurityException {
        try {
            byte[] certbytes = this.getCertificateBytes();
            CertificateFactory certFact = CertificateFactory.getInstance(JCA_CERT_ID);
            X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(certbytes));
            if (cert != null) {
                return cert;
            }
            return null;
        }
        catch (CertificateException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        X509Certificate cert = this.getX509Certificate();
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public boolean equals(Object obj) {
        try {
            if (!obj.getClass().getName().equals(this.getClass().getName())) {
                return false;
            }
            XMLX509Certificate other = (XMLX509Certificate)obj;
            return JavaUtils.binaryCompare(other.getCertificateBytes(), this.getCertificateBytes());
        }
        catch (XMLSecurityException ex) {
            return false;
        }
    }

    public String getBaseLocalName() {
        return "X509Certificate";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

