/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.content.keyvalues;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.keyvalues.KeyValueContent;
import com.systinet.wasp.security.secext.utils.I18n;
import com.systinet.wasp.security.secext.utils.JavaUtils;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RSAKeyValue
extends SignatureElementProxy
implements KeyValueContent {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$content$keyvalues$RSAKeyValue == null ? (class$com$systinet$wasp$security$secext$keys$content$keyvalues$RSAKeyValue = RSAKeyValue.class$("com.systinet.wasp.security.secext.keys.content.keyvalues.RSAKeyValue")) : class$com$systinet$wasp$security$secext$keys$content$keyvalues$RSAKeyValue).getName());
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$content$keyvalues$RSAKeyValue;

    public RSAKeyValue(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public RSAKeyValue(Document doc, BigInteger modulus, BigInteger exponent) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addBigIntegerElement(modulus, "Modulus");
        this.addBigIntegerElement(exponent, "Exponent");
    }

    public RSAKeyValue(Document doc, Key key) throws IllegalArgumentException {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        if (!JavaUtils.implementsInterface(key, "java.security.interfaces.RSAPublicKey")) {
            Object[] exArgs = new Object[]{"RSAKeyValue", key.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", exArgs));
        }
        this.addBigIntegerElement(((RSAPublicKey)key).getModulus(), "Modulus");
        this.addBigIntegerElement(((RSAPublicKey)key).getPublicExponent(), "Exponent");
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        try {
            KeyFactory rsaFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rsaKeyspec = new RSAPublicKeySpec(this.getBigIntegerFromChildElement("Modulus", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("Exponent", "http://www.w3.org/2000/09/xmldsig#"));
            PublicKey pk = rsaFactory.generatePublic(rsaKeyspec);
            return pk;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidKeySpecException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public String getBaseLocalName() {
        return "RSAKeyValue";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

