/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.content.keyvalues;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.keyvalues.KeyValueContent;
import com.systinet.wasp.security.secext.utils.I18n;
import com.systinet.wasp.security.secext.utils.JavaUtils;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DSAKeyValue
extends SignatureElementProxy
implements KeyValueContent {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$content$keyvalues$DSAKeyValue == null ? (class$com$systinet$wasp$security$secext$keys$content$keyvalues$DSAKeyValue = DSAKeyValue.class$("com.systinet.wasp.security.secext.keys.content.keyvalues.DSAKeyValue")) : class$com$systinet$wasp$security$secext$keys$content$keyvalues$DSAKeyValue).getName());
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$content$keyvalues$DSAKeyValue;

    public DSAKeyValue(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public DSAKeyValue(Document doc, BigInteger P, BigInteger Q, BigInteger G, BigInteger Y) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addBigIntegerElement(P, "P");
        this.addBigIntegerElement(Q, "Q");
        this.addBigIntegerElement(G, "G");
        this.addBigIntegerElement(Y, "Y");
    }

    public DSAKeyValue(Document doc, Key key) throws IllegalArgumentException {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        if (!JavaUtils.implementsInterface(key, "java.security.interfaces.DSAPublicKey")) {
            Object[] exArgs = new Object[]{"DSAKeyValue", key.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", exArgs));
        }
        this.addBigIntegerElement(((DSAPublicKey)key).getParams().getP(), "P");
        this.addBigIntegerElement(((DSAPublicKey)key).getParams().getQ(), "Q");
        this.addBigIntegerElement(((DSAPublicKey)key).getParams().getG(), "G");
        this.addBigIntegerElement(((DSAPublicKey)key).getY(), "Y");
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        try {
            DSAPublicKeySpec pkspec = new DSAPublicKeySpec(this.getBigIntegerFromChildElement("Y", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("P", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("Q", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("G", "http://www.w3.org/2000/09/xmldsig#"));
            KeyFactory dsaFactory = KeyFactory.getInstance("DSA");
            PublicKey pk = dsaFactory.generatePublic(pkspec);
            return pk;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidKeySpecException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public String getBaseLocalName() {
        return "DSAKeyValue";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

