/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.Init;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.ContentHandlerAlreadyRegisteredException;
import com.systinet.wasp.security.secext.keys.content.KeyName;
import com.systinet.wasp.security.secext.keys.content.KeyValue;
import com.systinet.wasp.security.secext.keys.content.MgmtData;
import com.systinet.wasp.security.secext.keys.content.PGPData;
import com.systinet.wasp.security.secext.keys.content.RetrievalMethod;
import com.systinet.wasp.security.secext.keys.content.SPKIData;
import com.systinet.wasp.security.secext.keys.content.X509Data;
import com.systinet.wasp.security.secext.keys.content.keyvalues.DSAKeyValue;
import com.systinet.wasp.security.secext.keys.content.keyvalues.RSAKeyValue;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolver;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverException;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverSpi;
import com.systinet.wasp.security.secext.keys.storage.StorageResolver;
import com.systinet.wasp.security.secext.transforms.Transforms;
import com.systinet.wasp.security.secext.utils.IdResolver;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfo
extends SignatureElementProxy {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$KeyInfo == null ? (class$com$systinet$wasp$security$secext$keys$KeyInfo = KeyInfo.class$("com.systinet.wasp.security.secext.keys.KeyInfo")) : class$com$systinet$wasp$security$secext$keys$KeyInfo).getName());
    Element _dsns = null;
    Vector _internalKeyResolvers = new Vector();
    Vector _storageResolvers = new Vector();
    static boolean _alreadyInitialized = false;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$KeyInfo;

    public KeyInfo(Document doc) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._dsns = XMLUtils.createDSctx(this._doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    public KeyInfo(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        this._dsns = XMLUtils.createDSctx(this._doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    public void setId(String Id) {
        if (this._state == 0 && Id != null) {
            this._constructionElement.setAttributeNS(null, "Id", Id);
            IdResolver.registerElementById(this._constructionElement, Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addKeyName(String keynameString) {
        this.add(new KeyName(this._doc, keynameString));
    }

    public void add(KeyName keyname) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyname.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addKeyValue(PublicKey pk) {
        this.add(new KeyValue(this._doc, pk));
    }

    public void addKeyValue(Element unknownKeyValueElement) {
        this.add(new KeyValue(this._doc, unknownKeyValueElement));
    }

    public void add(DSAKeyValue dsakeyvalue) {
        this.add(new KeyValue(this._doc, dsakeyvalue));
    }

    public void add(RSAKeyValue rsakeyvalue) {
        this.add(new KeyValue(this._doc, rsakeyvalue));
    }

    public void add(PublicKey pk) {
        this.add(new KeyValue(this._doc, pk));
    }

    public void add(KeyValue keyvalue) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyvalue.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addMgmtData(String mgmtdata) {
        this.add(new MgmtData(this._doc, mgmtdata));
    }

    public void add(MgmtData mgmtdata) {
        if (this._state == 0) {
            this._constructionElement.appendChild(mgmtdata.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(PGPData pgpdata) {
        if (this._state == 0) {
            this._constructionElement.appendChild(pgpdata.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addRetrievalMethod(String URI2, Transforms transforms, String Type2) {
        this.add(new RetrievalMethod(this._doc, URI2, transforms, Type2));
    }

    public void add(RetrievalMethod retrievalmethod) {
        if (this._state == 0) {
            this._constructionElement.appendChild(retrievalmethod.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(SPKIData spkidata) {
        if (this._state == 0) {
            this._constructionElement.appendChild(spkidata.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(X509Data x509data) throws XMLSecurityException {
        if (this._state == 0) {
            this._constructionElement.appendChild(x509data.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addUnknownElement(Element element) {
        if (this._state == 0) {
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthX509Data() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public int lengthUnknownElement() {
        int res = 0;
        NodeList nl = this._constructionElement.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node current = nl.item(i);
            if (current.getNodeType() == 1 && current.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
                ++res;
            }
            ++i;
        }
        return res;
    }

    public KeyName itemKeyName(int i) throws XMLSecurityException {
        Element e = this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "KeyName");
        if (e != null) {
            return new KeyName(e, this._baseURI);
        }
        return null;
    }

    public KeyValue itemKeyValue(int i) throws XMLSecurityException {
        Element e = this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "KeyValue");
        if (e != null) {
            return new KeyValue(e, this._baseURI);
        }
        return null;
    }

    public MgmtData itemMgmtData(int i) throws XMLSecurityException {
        Element e = this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "MgmtData");
        if (e != null) {
            return new MgmtData(e, this._baseURI);
        }
        return null;
    }

    public PGPData itemPGPData(int i) throws XMLSecurityException {
        Element e = this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "PGPData");
        if (e != null) {
            return new PGPData(e, this._baseURI);
        }
        return null;
    }

    public RetrievalMethod itemRetrievalMethod(int i) throws XMLSecurityException {
        Element e = this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
        if (e != null) {
            return new RetrievalMethod(e, this._baseURI);
        }
        return null;
    }

    public SPKIData itemSPKIData(int i) throws XMLSecurityException {
        Element e = this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "SPKIData");
        if (e != null) {
            return new SPKIData(e, this._baseURI);
        }
        return null;
    }

    public X509Data itemX509Data(int i) throws XMLSecurityException {
        Element e = this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "X509Data");
        if (e != null) {
            return new X509Data(e, this._baseURI);
        }
        return null;
    }

    public Element itemUnknownElement(int i) {
        NodeList nl = this._constructionElement.getChildNodes();
        int res = 0;
        int j = 0;
        while (j < nl.getLength()) {
            Node current = nl.item(j);
            if (current.getNodeType() == 1 && current.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && ++res == i) {
                return (Element)current;
            }
            ++j;
        }
        return null;
    }

    public boolean isEmpty() {
        return this._constructionElement.getChildNodes().getLength() == 0;
    }

    public boolean containsKeyName() {
        return this.lengthKeyName() > 0;
    }

    public boolean containsKeyValue() {
        return this.lengthKeyValue() > 0;
    }

    public boolean containsMgmtData() {
        return this.lengthMgmtData() > 0;
    }

    public boolean containsPGPData() {
        return this.lengthPGPData() > 0;
    }

    public boolean containsRetrievalMethod() {
        return this.lengthRetrievalMethod() > 0;
    }

    public boolean containsSPKIData() {
        return this.lengthSPKIData() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        SecretKey pk = this.getSecretKeyFromInternalResolvers();
        if (pk != null) {
            return pk;
        }
        pk = this.getSecretKeyFromStaticResolvers();
        if (pk != null) {
            return pk;
        }
        return null;
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey pk = this.getPublicKeyFromInternalResolvers();
        if (pk != null) {
            return pk;
        }
        pk = this.getPublicKeyFromStaticResolvers();
        if (pk != null) {
            return pk;
        }
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        int i = 0;
        while (i < KeyResolver.length()) {
            KeyResolver keyResolver = KeyResolver.item(i);
            int j = 0;
            while (j < this._constructionElement.getChildNodes().getLength()) {
                Node currentChild = this._constructionElement.getChildNodes().item(j);
                if (currentChild.getNodeType() == 1) {
                    if (this._storageResolvers.size() == 0) {
                        PublicKey pk;
                        StorageResolver storage = null;
                        if (keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) && (pk = keyResolver.resolvePublicKey((Element)currentChild, this.getBaseURI(), storage)) != null) {
                            return pk;
                        }
                    } else {
                        int k = 0;
                        while (k < this._storageResolvers.size()) {
                            PublicKey pk;
                            StorageResolver storage = (StorageResolver)this._storageResolvers.elementAt(k);
                            if (keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) && (pk = keyResolver.resolvePublicKey((Element)currentChild, this.getBaseURI(), storage)) != null) {
                                return pk;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        int i = 0;
        while (i < this.lengthInternalKeyResolver()) {
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            int j = 0;
            while (j < this._constructionElement.getChildNodes().getLength()) {
                Node currentChild = this._constructionElement.getChildNodes().item(j);
                if (currentChild.getNodeType() == 1) {
                    if (this._storageResolvers.size() == 0) {
                        PublicKey pk;
                        StorageResolver storage = null;
                        if (keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) && (pk = keyResolver.engineResolvePublicKey((Element)currentChild, this.getBaseURI(), storage)) != null) {
                            return pk;
                        }
                    } else {
                        int k = 0;
                        while (k < this._storageResolvers.size()) {
                            PublicKey pk;
                            StorageResolver storage = (StorageResolver)this._storageResolvers.elementAt(k);
                            if (keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) && (pk = keyResolver.engineResolvePublicKey((Element)currentChild, this.getBaseURI(), storage)) != null) {
                                return pk;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    SecretKey getSecretKeyFromStaticResolvers() throws KeyResolverException {
        int i = 0;
        while (i < KeyResolver.length()) {
            KeyResolver keyResolver = KeyResolver.item(i);
            int j = 0;
            while (j < this._constructionElement.getChildNodes().getLength()) {
                Node currentChild = this._constructionElement.getChildNodes().item(j);
                if (currentChild.getNodeType() == 1) {
                    if (this._storageResolvers.size() == 0) {
                        SecretKey pk;
                        StorageResolver storage = null;
                        if (keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) && (pk = keyResolver.resolveSecretKey((Element)currentChild, this.getBaseURI(), storage)) != null) {
                            return pk;
                        }
                    } else {
                        int k = 0;
                        while (k < this._storageResolvers.size()) {
                            SecretKey pk;
                            StorageResolver storage = (StorageResolver)this._storageResolvers.elementAt(k);
                            if (keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) && (pk = keyResolver.resolveSecretKey((Element)currentChild, this.getBaseURI(), storage)) != null) {
                                return pk;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    SecretKey getSecretKeyFromInternalResolvers() throws KeyResolverException {
        int i = 0;
        while (i < this.lengthInternalKeyResolver()) {
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            int j = 0;
            while (j < this._constructionElement.getChildNodes().getLength()) {
                Node currentChild = this._constructionElement.getChildNodes().item(j);
                if (currentChild.getNodeType() == 1) {
                    if (this._storageResolvers.size() == 0) {
                        SecretKey pk;
                        StorageResolver storage = null;
                        if (keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) && (pk = keyResolver.engineResolveSecretKey((Element)currentChild, this.getBaseURI(), storage)) != null) {
                            return pk;
                        }
                    } else {
                        int k = 0;
                        while (k < this._storageResolvers.size()) {
                            SecretKey pk;
                            StorageResolver storage = (StorageResolver)this._storageResolvers.elementAt(k);
                            if (keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) && (pk = keyResolver.engineResolveSecretKey((Element)currentChild, this.getBaseURI(), storage)) != null) {
                                return pk;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate cert = this.getX509CertificateFromInternalResolvers();
        if (cert != null) {
            return cert;
        }
        cert = this.getX509CertificateFromStaticResolvers();
        if (cert != null) {
            return cert;
        }
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        int i = 0;
        while (i < KeyResolver.length()) {
            KeyResolver keyResolver = KeyResolver.item(i);
            int j = 0;
            while (j < this._constructionElement.getChildNodes().getLength()) {
                Node currentChild = this._constructionElement.getChildNodes().item(j);
                if (currentChild.getNodeType() == 1) {
                    if (this._storageResolvers.size() == 0) {
                        X509Certificate cert;
                        StorageResolver storage = null;
                        if (keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) && (cert = keyResolver.resolveX509Certificate((Element)currentChild, this.getBaseURI(), storage)) != null) {
                            return cert;
                        }
                    } else {
                        int k = 0;
                        while (k < this._storageResolvers.size()) {
                            X509Certificate cert;
                            StorageResolver storage = (StorageResolver)this._storageResolvers.elementAt(k);
                            if (keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) && (cert = keyResolver.resolveX509Certificate((Element)currentChild, this.getBaseURI(), storage)) != null) {
                                return cert;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        int i = 0;
        while (i < this.lengthInternalKeyResolver()) {
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            int j = 0;
            while (j < this._constructionElement.getChildNodes().getLength()) {
                Node currentChild = this._constructionElement.getChildNodes().item(j);
                if (currentChild.getNodeType() == 1) {
                    if (this._storageResolvers.size() == 0) {
                        X509Certificate cert;
                        StorageResolver storage = null;
                        if (keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) && (cert = keyResolver.engineResolveX509Certificate((Element)currentChild, this.getBaseURI(), storage)) != null) {
                            return cert;
                        }
                    } else {
                        int k = 0;
                        while (k < this._storageResolvers.size()) {
                            X509Certificate cert;
                            StorageResolver storage = (StorageResolver)this._storageResolvers.elementAt(k);
                            if (keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) && (cert = keyResolver.engineResolveX509Certificate((Element)currentChild, this.getBaseURI(), storage)) != null) {
                                return cert;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void registerInternalKeyResolver(KeyResolverSpi realKeyResolver) {
        this._internalKeyResolvers.add(realKeyResolver);
    }

    int lengthInternalKeyResolver() {
        return this._internalKeyResolvers.size();
    }

    KeyResolverSpi itemInternalKeyResolver(int i) {
        return (KeyResolverSpi)this._internalKeyResolvers.elementAt(i);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (storageResolver != null) {
            this._storageResolvers.add(storageResolver);
        }
    }

    Vector getStorageResolvers() {
        return this._storageResolvers;
    }

    public static void init() {
        if (!_alreadyInitialized) {
            if (cat == null) {
                cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$KeyInfo == null ? (class$com$systinet$wasp$security$secext$keys$KeyInfo = KeyInfo.class$("com.systinet.wasp.security.secext.keys.KeyInfo")) : class$com$systinet$wasp$security$secext$keys$KeyInfo).getName());
                cat.error("Had to assign cat in the init() function");
            }
            _alreadyInitialized = true;
        }
    }

    public static void registerKeyInfoContentHandler(String namespace, String localname, String implementingClass) throws ContentHandlerAlreadyRegisteredException {
        Init.registerKeyInfoContentHandler(namespace, localname, implementingClass);
    }

    public String getBaseLocalName() {
        return "KeyInfo";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

