/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.implementations.BC;

import com.systinet.wasp.security.secext.algorithms.JCEMapper;
import com.systinet.wasp.security.secext.algorithms.MessageDigestAlgorithm;
import com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethodSpi;
import com.systinet.wasp.security.secext.algorithms.encryption.helper.TripleDESWrapper;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyWrapImpl_TRIPLEDES_BC
extends EncryptionMethodSpi {
    Cipher _cipher;
    MessageDigest _sha1digest;

    public int engineGetIvLength() {
        return 8;
    }

    public String getImplementedAlgorithmURI() {
        return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    }

    public String getRequiredProviderName() {
        return "BC";
    }

    public int getImplementedAlgorithmType() {
        return 4;
    }

    public int engineGetBlockSize() {
        return this._cipher.getBlockSize();
    }

    public EncryptionMethodParams engineInit(Document doc, EncryptionMethodParams params) throws XMLSecurityException {
        if (params != null) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            MessageDigestAlgorithm mda = MessageDigestAlgorithm.getInstance(doc, "http://www.w3.org/2000/09/xmldsig#sha1");
            this._sha1digest = mda.getAlgorithm();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        return params;
    }

    public EncryptionMethodParams engineInit(Element encryptionMethodElem) throws XMLSecurityException {
        if (encryptionMethodElem.getChildNodes().getLength() != 0) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            MessageDigestAlgorithm mda = MessageDigestAlgorithm.getInstance(encryptionMethodElem.getOwnerDocument(), "http://www.w3.org/2000/09/xmldsig#sha1");
            this._sha1digest = mda.getAlgorithm();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        return null;
    }

    public byte[] engineWrap(Key contentKey, Key wrapKey) throws XMLSecurityException {
        return this.engineWrap(contentKey, wrapKey, null);
    }

    public byte[] engineWrap(Key contentKey, Key wrapKey, byte[] IV) throws XMLSecurityException {
        try {
            TripleDESWrapper wrapper = new TripleDESWrapper(this._cipher, this._sha1digest);
            return wrapper.wrap(contentKey.getEncoded(), wrapKey, IV);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public Key engineUnwrap(byte[] wrappedKey, Key wrapKey, String wrappedKeyURI) throws XMLSecurityException {
        try {
            String wrappedKeyAlgorithm = JCEMapper.translateURItoJCEID(wrappedKeyURI, this.getRequiredProviderName()).getAlgorithmID();
            int wrappedKeyType = JCEMapper.getKeyTypeFromURI(wrappedKeyURI);
            TripleDESWrapper wrapper = new TripleDESWrapper(this._cipher, this._sha1digest);
            byte[] encoded = wrapper.unwrap(wrappedKey, wrapKey);
            if (wrappedKeyType == 3) {
                return new SecretKeySpec(encoded, wrappedKeyAlgorithm);
            }
            try {
                KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm, this.getRequiredProviderName());
                if (wrappedKeyType == 1) {
                    return kf.generatePublic(new X509EncodedKeySpec(encoded));
                }
                if (wrappedKeyType == 2) {
                    return kf.generatePrivate(new PKCS8EncodedKeySpec(encoded));
                }
            }
            catch (NoSuchProviderException e) {
                throw new InvalidKeyException("Unknown key type " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeyException("Unknown key type " + e.getMessage());
            }
            catch (InvalidKeySpecException e2) {
                throw new InvalidKeyException("Unknown key type " + e2.getMessage());
            }
            throw new InvalidKeyException("Unknown key type " + wrappedKeyType);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] engineEncrypt(byte[] plaintextBytes, Key contentKey) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }

    public byte[] engineEncrypt(byte[] plaintextBytes, Key contentKey, byte[] IV) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }

    public byte[] engineDecrypt(byte[] ciphertextBytes, Key contentKey) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }
}

