/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.helper;

import com.systinet.wasp.security.secext.algorithms.encryption.helper.InvalidCipherTextException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class PKCS15Cipher {
    private static int HEADER_LENGTH = 0;
    Cipher _cipher;
    int _cipherMode;
    SecureRandom _secureRandom;

    public PKCS15Cipher(Cipher rsaCipher) {
        this._cipher = rsaCipher;
    }

    public void init(int mode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this._cipherMode = mode;
        this._secureRandom = secureRandom;
        this._cipher.init(this._cipherMode, key, this._secureRandom);
    }

    public int getInputBlockSize() {
        int baseBlockSize = this._cipher.getBlockSize();
        if (this._cipherMode == 1) {
            return baseBlockSize - HEADER_LENGTH;
        }
        return baseBlockSize;
    }

    public int getOutputBlockSize() {
        int baseBlockSize = this._cipher.getBlockSize();
        if (this._cipherMode == 1) {
            return baseBlockSize;
        }
        return baseBlockSize - HEADER_LENGTH - 1;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        if (this._cipherMode == 1) {
            return this.encodeBlock(in, inOff, inLen);
        }
        if (this._cipherMode == 2) {
            return this.decodeBlock(in, inOff, inLen);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        block = new byte[this.getInputBlockSize()];
        this._secureRandom.nextBytes(block);
        block[0] = 2;
        i = 1;
        ** GOTO lbl10
        {
            block[i] = (byte)this._secureRandom.nextInt();
            do {
                if (block[i] == 0) continue block0;
                ++i;
lbl10:
                // 2 sources

            } while (i != block.length - inLen - 1);
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        return this._cipher.doFinal(block, 0, block.length);
    }

    public byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        byte[] block = this._cipher.doFinal(in, inOff, inLen);
        if (block.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("encryption.RSAPKCS15.blockTruncated");
        }
        if (block[0] != 2) {
            throw new InvalidCipherTextException("encryption.RSAPKCS15.unknownBlockType");
        }
        int start = 1;
        while (start != block.length) {
            if (block[start] == 0) break;
            ++start;
        }
        if (++start >= block.length || start < HEADER_LENGTH) {
            throw new InvalidCipherTextException("encryption.RSAPKCS15.noDataInBlock");
        }
        byte[] result = new byte[block.length - start];
        System.arraycopy(block, start, result, 0, result.length);
        return result;
    }
}

