/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.xml.security.BinaryLicense;
import com.idoox.xml.security.KeyInfo;
import com.idoox.xml.security.UriResolver;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.CertificateContent;
import org.idoox.xml.security.KeyContent;
import org.idoox.xml.security.SignatureException;

public class LicenseLocation
extends KeyContent
implements CertificateContent {
    public static final int LICENSE_UNKNOWN = -1;
    public static final int LICENSE_KEYINFO = 0;
    public static final int LICENSE_BINARY = 1;
    private int licenseType = -1;
    private BinaryLicense binaryLicense = null;
    private KeyInfo keyInfo = null;

    public LicenseLocation() {
        this.qname = KeyContent.LICENSE_LOCATION_KEYCONTENT;
    }

    public KeyContent newInstance() {
        return new LicenseLocation();
    }

    public void construct(Object keyData) throws SignatureException {
    }

    public String toCanonicalXMLString(String signaturePrefix) throws SignatureException {
        StringBuffer sb = new StringBuffer();
        sb.append("<wssec:licenseLocation xmlns:wssec=\"http://schemas.xmlsoap.org/ws/2001/10/security\">");
        String uri = (String)this.contentData.get("LICENSE_LOCATION_URI");
        sb.append(uri);
        sb.append("</wssec:licenseLocation>");
        return sb.toString();
    }

    private int getLicenseType(Tokenizer licenseTokenizer) throws SignatureException {
        try {
            if (licenseTokenizer.getLocalName().equals("binaryLicense") && "http://schemas.xmlsoap.org/ws/2001/10/license".equals(licenseTokenizer.getNamespace())) {
                return 1;
            }
            if (licenseTokenizer.getLocalName().equals("KeyInfo") && "http://www.w3.org/2000/09/xmldsig#".equals(licenseTokenizer.getNamespace())) {
                return 0;
            }
            return -1;
        }
        catch (Exception e) {
            throw new SignatureException("Error getting LicenseType. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public void construct(Tokenizer tokenizer) throws SignatureException {
        try {
            tokenizer.next();
            String uri = tokenizer.readContent();
            tokenizer.next();
            Tokenizer defaultDocument = (Tokenizer)this.contentData.get("LICENSE_LOCATION_DEFFAULT_DOCUMENT");
            Tokenizer licenseTokenizer = UriResolver.resolve(uri, defaultDocument);
            this.licenseType = this.getLicenseType(licenseTokenizer);
            if (this.licenseType == 0) {
                this.keyInfo = new KeyInfo(licenseTokenizer, this.contentData);
            }
            if (this.licenseType == 1) {
                this.binaryLicense = new BinaryLicense(licenseTokenizer, this.contentData);
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating LicenseLocation. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public PublicKey getPublicKey() throws SignatureException {
        if (this.keyInfo != null) {
            return this.keyInfo.getPublicKey();
        }
        if (this.binaryLicense != null) {
            return this.binaryLicense.getPublicKey();
        }
        throw new SignatureException("cannot generate key from licenseLocation");
    }

    public Certificate[] getCertificates() {
        if (this.licenseType == 0) {
            if (this.keyInfo != null) {
                return this.keyInfo.getCertificates();
            }
            return null;
        }
        if (this.licenseType == 1) {
            if (this.binaryLicense != null) {
                return this.binaryLicense.getCertificates();
            }
            return null;
        }
        return null;
    }
}

