/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.server;

import com.idoox.debug.Category;
import com.idoox.wasp.config.SecurityModuleConfig;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.security.spi.ServerSecurityProvider;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class CurrentImpl
extends org.idoox.security.server.Current {
    public static final String RECEIVED_CREDENTIALS_NAME = "security.receivedCredentials";
    public static final String CREDENTIALS_NAME = "security.credentials";
    public static final String INITIATING_PROVIDER = "security.provider.initiating";
    public static final String ACCEPTING_PROVIDERS = "security.provider.accepting";
    private static final Category log = Category.getCategory((String)"com.idoox.wasp.security.server.CurrentImpl");
    private HashMap providers = new HashMap(11, 0.75f);
    private String[] providerNames;
    static /* synthetic */ Class class$com$idoox$wasp$config$SecurityModuleConfig;

    public CurrentImpl() {
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable c = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
        if (c == null) {
            log.warn("Cannot find security module configuration, no default security providers will be available");
            return;
        }
        SecurityModuleConfig config = (SecurityModuleConfig)c.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = CurrentImpl.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
        SecurityModuleConfig.SecurityProvider[] providers = config.getSecurityProviders();
        if (providers == null || providers.length == 0) {
            log.warn("No security providers configured");
            return;
        }
        int i = 0;
        while (i < providers.length) {
            Provider p = new Provider(providers[i].getProviderName(), providers[i].getProviderClass());
            this.providers.put(p.name, p);
            ++i;
        }
        this.providerNames = new String[this.providers.size()];
        Iterator keys = this.providers.keySet().iterator();
        int i2 = 0;
        while (keys.hasNext()) {
            this.providerNames[i2++] = (String)keys.next();
        }
    }

    public void setCredentials(Credentials[] newCreds) {
        if (newCreds == null || newCreds.length == 0) {
            throw new IllegalArgumentException("New credentials cannot be null or empty.");
        }
        Map serviceData = this.getServiceData();
        Credentials[] creds = (Credentials[])serviceData.get(CREDENTIALS_NAME);
        Credentials[] toSetCreds = CurrentImpl.makeUniqueCredentials(creds, newCreds);
        serviceData.put(CREDENTIALS_NAME, toSetCreds);
    }

    public void setCredentials(Credentials[] newCreds, Map parameters) {
        if (newCreds == null || newCreds.length == 0) {
            throw new IllegalArgumentException("New credentials cannot be null or empty.");
        }
        Credentials[] creds = (Credentials[])parameters.get(CREDENTIALS_NAME);
        Credentials[] toSetCreds = CurrentImpl.makeUniqueCredentials(creds, newCreds);
        parameters.put(CREDENTIALS_NAME, toSetCreds);
    }

    private static Credentials[] makeUniqueCredentials(Credentials[] currentCredentials, Credentials[] addedCredentials) {
        Credentials[] mergedCreds = null;
        if (currentCredentials == null || currentCredentials.length == 0) {
            mergedCreds = new Credentials[addedCredentials.length];
            System.arraycopy(addedCredentials, 0, mergedCreds, 0, addedCredentials.length);
        } else {
            mergedCreds = new Credentials[addedCredentials.length + currentCredentials.length];
            System.arraycopy(addedCredentials, 0, mergedCreds, 0, addedCredentials.length);
            System.arraycopy(currentCredentials, 0, mergedCreds, addedCredentials.length, currentCredentials.length);
        }
        int position = 0;
        int i = 0;
        while (i < mergedCreds.length) {
            String providerName;
            Credentials creds = mergedCreds[i];
            if (creds != null && (providerName = creds.getProviderName()) != null) {
                boolean present = false;
                int j = 0;
                while (j < i) {
                    Credentials prevCreds = mergedCreds[j];
                    if (prevCreds != null && prevCreds.getProviderName() != null && prevCreds.getProviderName().equals(providerName)) {
                        present = true;
                        break;
                    }
                    ++j;
                }
                if (present) {
                    mergedCreds[i] = null;
                } else {
                    if (i != position) {
                        mergedCreds[position] = creds;
                    }
                    ++position;
                }
            }
            ++i;
        }
        if (mergedCreds.length != position) {
            Credentials[] tmp = new Credentials[position];
            System.arraycopy(mergedCreds, 0, tmp, 0, position);
            mergedCreds = tmp;
        }
        return mergedCreds;
    }

    public Credentials[] getCredentials() {
        return (Credentials[])this.getServiceData().get(CREDENTIALS_NAME);
    }

    public PrincipalAuthenticator getAuthenticator() {
        Map serviceData = this.getServiceData();
        Provider[] acceptingProviders = (Provider[])serviceData.get(ACCEPTING_PROVIDERS);
        try {
            if (acceptingProviders == null || acceptingProviders.length == 0) {
                throw new RuntimeException("Default accepting providers not specified in configuration");
            }
            if (acceptingProviders.length == 1) {
                return acceptingProviders[0].getInstance().getAuthenticator();
            }
            throw new RuntimeException("More accepting provider, use Current.getAuthenticator(String providerName) instead");
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public PrincipalAuthenticator getAuthenticator(String provider) throws NoSuchProviderException {
        Provider p = (Provider)this.providers.get(provider);
        if (p == null) {
            throw new NoSuchProviderException("Provider " + provider + " cannot be found");
        }
        return p.getInstance().getAuthenticator();
    }

    public ReceivedCredentials getReceivedCredentials() {
        Map contextData = null;
        try {
            contextData = Current.getCallContext().getContextData();
        }
        catch (NullPointerException e) {
            throw new RuntimeWrappedException("Unable to obtain call context - you are probably calling the method getReceivedCredentials() outside a Systinet Server call");
        }
        return (ReceivedCredentials)contextData.get(RECEIVED_CREDENTIALS_NAME);
    }

    public void setReceivedCredentials(ReceivedCredentials recvCreds) {
        ReceivedCredentials creds = (ReceivedCredentials)Current.getCallContext().getContextData().get(RECEIVED_CREDENTIALS_NAME);
        if (creds == null) {
            Current.getCallContext().getContextData().put(RECEIVED_CREDENTIALS_NAME, recvCreds);
        } else {
            try {
                Iterator<Principal> princsIter = recvCreds.getSubject().getPrincipals().iterator();
                Set<Principal> curRecvPrincs = creds.getSubject().getPrincipals();
                while (princsIter.hasNext()) {
                    curRecvPrincs.add(princsIter.next());
                }
            }
            catch (Exception e) {
                log.debug("Attempting to set wrong received credentials", (Throwable)e);
            }
        }
    }

    public void resetCredentials() {
        Map serviceData = this.getServiceData();
        serviceData.remove(CREDENTIALS_NAME);
        try {
            Provider p = (Provider)serviceData.get(INITIATING_PROVIDER);
            if (p != null) {
                p.getInstance().resetContexts(null);
            }
            Provider[] ps = (Provider[])serviceData.get(ACCEPTING_PROVIDERS);
            if (p != null && ps != null) {
                int i = 0;
                while (i < ps.length) {
                    ps[i].getInstance().resetContexts(null);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void resetCredentials(Map parameters) {
        parameters.remove(CREDENTIALS_NAME);
        try {
            Provider p = (Provider)parameters.get(INITIATING_PROVIDER);
            if (p != null) {
                p.getInstance().resetContexts(null);
            }
            Provider[] ps = (Provider[])parameters.get(ACCEPTING_PROVIDERS);
            if (p != null && ps != null) {
                int i = 0;
                while (i < ps.length) {
                    ps[i].getInstance().resetContexts(null);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String[] getProviders() {
        return this.providerNames;
    }

    public void registerProvider(String name, String implClassName) {
        if (this.providers.containsKey(name)) {
            throw new RuntimeException("Provider " + name + " already registered");
        }
        String[] tmp = new String[this.providerNames.length + 1];
        System.arraycopy(this.providerNames, 0, tmp, 0, this.providerNames.length);
        tmp[tmp.length - 1] = name;
        this.providers.put(name, new Provider(name, implClassName));
    }

    public Properties getProviderProperties(String name) throws NoSuchProviderException {
        Provider p = (Provider)this.providers.get(name);
        if (p == null) {
            throw new NoSuchProviderException("Provider " + name + " cannot be found");
        }
        return p.getInstance().getProperties();
    }

    public void setCurrentProvider(String name) throws NoSuchProviderException {
        Map serviceData = this.getServiceData();
        Provider newProvider = null;
        if (name != null && (newProvider = (Provider)this.providers.get(name)) == null) {
            throw new NoSuchProviderException("Provider " + name + " cannot be found");
        }
        Provider oldInitProvider = (Provider)serviceData.get(INITIATING_PROVIDER);
        Provider[] oldAcceptProviders = (Provider[])serviceData.get(ACCEPTING_PROVIDERS);
        if (oldInitProvider != null) {
            oldInitProvider.getInstance().unsetCurrentInitiating(null);
        }
        if (oldAcceptProviders != null) {
            int i = 0;
            while (i < oldAcceptProviders.length) {
                oldAcceptProviders[i].getInstance().unsetCurrentAccepting(null);
                ++i;
            }
        }
        if (newProvider != null) {
            newProvider.getInstance().setCurrentAccepting(null);
            serviceData.put(INITIATING_PROVIDER, newProvider);
            serviceData.put(ACCEPTING_PROVIDERS, new Provider[]{newProvider});
        } else {
            serviceData.put(INITIATING_PROVIDER, null);
            serviceData.put(ACCEPTING_PROVIDERS, null);
        }
    }

    public String[] getCurrentAcceptingProviders() {
        Map serviceData = this.getServiceData();
        Provider[] acceptingProviders = (Provider[])serviceData.get(ACCEPTING_PROVIDERS);
        if (acceptingProviders == null || acceptingProviders.length == 0) {
            return null;
        }
        String[] retval = new String[acceptingProviders.length];
        int i = 0;
        while (i < retval.length) {
            retval[i] = acceptingProviders[i].name;
            ++i;
        }
        return retval;
    }

    public void setCurrentAcceptingProviders(String[] names) throws NoSuchProviderException {
        Provider[] oldProviders;
        Map serviceData = this.getServiceData();
        Provider[] newProviders = null;
        if (names != null && names.length > 0) {
            newProviders = new Provider[names.length];
            int i = 0;
            while (i < names.length) {
                Provider p = (Provider)this.providers.get(names[i]);
                if (p == null) {
                    throw new NoSuchProviderException("Provider " + names[i] + " cannot be found");
                }
                newProviders[i] = p;
                ++i;
            }
        }
        if ((oldProviders = (Provider[])serviceData.get(ACCEPTING_PROVIDERS)) != null) {
            int i = 0;
            while (i < oldProviders.length) {
                oldProviders[i].getInstance().unsetCurrentAccepting(null);
                ++i;
            }
        }
        if (newProviders != null) {
            int i = 0;
            while (i < newProviders.length) {
                newProviders[i].getInstance().setCurrentAccepting(null);
                ++i;
            }
        }
        serviceData.put(ACCEPTING_PROVIDERS, newProviders);
    }

    public static String[] getAcceptingProviders(ServiceEndpointContext seContext) {
        Provider[] oldProviders = (Provider[])seContext.getContextData().get(ACCEPTING_PROVIDERS);
        if (oldProviders == null || oldProviders.length == 0) {
            return null;
        }
        String[] toRet = new String[oldProviders.length];
        int i = 0;
        while (i < oldProviders.length) {
            toRet[i] = oldProviders[i].name;
            ++i;
        }
        return toRet;
    }

    public static String getInitiatingProvider(ServiceEndpointContext seContext) {
        Provider provider = (Provider)seContext.getContextData().get(INITIATING_PROVIDER);
        if (provider == null) {
            return null;
        }
        return provider.name;
    }

    public void setCurrentAcceptingProviders(String[] names, Map parameters) throws NoSuchProviderException {
        Provider[] oldProviders;
        Provider[] newProviders = null;
        if (names != null && names.length > 0) {
            newProviders = new Provider[names.length];
            int i = 0;
            while (i < names.length) {
                Provider p = (Provider)this.providers.get(names[i]);
                if (p == null) {
                    throw new NoSuchProviderException("Provider " + names[i] + " cannot be found");
                }
                newProviders[i] = p;
                ++i;
            }
        }
        if ((oldProviders = (Provider[])parameters.get(ACCEPTING_PROVIDERS)) != null) {
            int i = 0;
            while (i < oldProviders.length) {
                oldProviders[i].getInstance().unsetCurrentAccepting(parameters);
                ++i;
            }
        }
        if (newProviders != null) {
            int i = 0;
            while (i < newProviders.length) {
                newProviders[i].getInstance().setCurrentAccepting(parameters);
                ++i;
            }
        }
        parameters.put(ACCEPTING_PROVIDERS, newProviders);
    }

    public String getCurrentInitiatingProvider() {
        Map serviceData = this.getServiceData();
        Provider p = (Provider)serviceData.get(INITIATING_PROVIDER);
        if (p == null) {
            return null;
        }
        return p.name;
    }

    public void setCurrentInitiatingProvider(String name) throws NoSuchProviderException {
        Map serviceData = this.getServiceData();
        Provider newProvider = null;
        if (name != null && (newProvider = (Provider)this.providers.get(name)) == null) {
            throw new NoSuchProviderException("Provider " + name + " cannot be found");
        }
        serviceData.put(INITIATING_PROVIDER, newProvider);
    }

    public void setCurrentInitiatingProvider(String name, Map parameters) throws NoSuchProviderException {
        Provider newProvider = null;
        if (name != null && (newProvider = (Provider)this.providers.get(name)) == null) {
            throw new NoSuchProviderException("Provider " + name + " cannot be found");
        }
        parameters.put(INITIATING_PROVIDER, newProvider);
    }

    public ServerSecurityProvider getProvider(String name) throws NoSuchProviderException {
        Provider p = (Provider)this.providers.get(name);
        if (p == null) {
            throw new NoSuchProviderException("Provider " + name + " not found");
        }
        return p.getInstance();
    }

    Map getServiceData() {
        ServiceEndpointContext sec = Current.getServiceEndpointContext();
        if (sec == null) {
            throw new RuntimeException("Not running in the service context.");
        }
        return sec.getContextData();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Provider {
        String name;
        String className;
        ServerSecurityProvider instance;

        Provider(String name, String className) {
            this.name = name;
            this.className = className;
        }

        ServerSecurityProvider getInstance() throws NoSuchProviderException {
            if (this.instance == null) {
                Provider provider = this;
                synchronized (provider) {
                    if (this.instance != null) {
                        ServerSecurityProvider serverSecurityProvider = this.instance;
                        return serverSecurityProvider;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.className);
                        this.instance = (ServerSecurityProvider)clazz.newInstance();
                    }
                    catch (Exception e) {
                        throw new NoSuchProviderException(e.getMessage());
                    }
                }
            }
            return this.instance;
        }
    }
}

