/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.providerbase;

import com.idoox.security.CredentialsImpl;
import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.wasp.Constants;
import java.io.UnsupportedEncodingException;
import javax.security.auth.callback.CallbackHandler;
import org.idoox.security.AuthResult;
import org.idoox.security.Config;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.PStore;
import org.idoox.security.util.RuntimeWrappedException;

public class PrincipalAuthenticatorBase
implements PrincipalAuthenticator {
    protected String providerName = null;
    protected String loginContextName = null;
    protected boolean checkEmptyPassword = false;

    public PrincipalAuthenticatorBase(String providerName, String loginContextName, boolean checkEmptyPassword) {
        this.providerName = providerName;
        this.loginContextName = loginContextName;
        this.checkEmptyPassword = checkEmptyPassword;
    }

    public AuthResult authenticate(String name, byte[] authData) {
        if (this.checkEmptyPassword && authData == null) {
            AuthResult retval = new AuthResult();
            retval.resultCode = 1;
            retval.errorReason = new RuntimeWrappedException("cannot authenticateuser " + name + " with null authData (password).");
            return retval;
        }
        AuthResult retval = new AuthResult();
        try {
            WaspCallbackHandler handler = new WaspCallbackHandler(name, new String(authData, Constants.UTF_8), Config.getId(), PStore.getInstance((String)"").getKeyStore(), PStore.getInstance((String)"").getUserStore());
            CredentialsImpl creds = new CredentialsImpl(name, this.providerName, this.loginContextName, (CallbackHandler)handler);
            if (creds.getAuthenticationStatus() != 0) {
                retval.resultCode = 1;
            } else {
                retval.creds = creds;
                retval.resultCode = 0;
            }
            return retval;
        }
        catch (RuntimeWrappedException e) {
            retval.resultCode = 1;
            retval.errorReason = e;
            return retval;
        }
        catch (RuntimeException e) {
            retval.resultCode = 1;
            retval.errorReason = new RuntimeWrappedException("cannot authenticate", (Throwable)e);
            return retval;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (BadPasswordException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public AuthResult continueAuthentication(byte[] responseData, Credentials creds) {
        AuthResult retval = new AuthResult();
        retval.resultCode = 1;
        retval.errorReason = new RuntimeWrappedException("PrincipalAuthenticator cannot perform continueAuthentication.");
        return retval;
    }
}

