/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.http.digest;

import com.idoox.debug.Category;
import com.idoox.security.httpdigest.AuthorizationStructureImpl;
import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.security.server.ReceivedCredentialsImpl;
import com.idoox.wasp.Constants;
import com.idoox.wasp.security.http.digest.AuthenticateStructure;
import com.systinet.wasp.ServiceManagerImpl;
import com.systinet.wasp.monitoring.events.LogEventAuthFailed;
import com.systinet.wasp.monitoring.events.LogEventAuthSuccess;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.idoox.config.Configurable;
import org.idoox.security.httpdigest.AuthorizationStructure;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.PStore;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.security.util.RuntimeWrappedException;
import org.idoox.transport.Connection;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.client.Endpoint;
import org.idoox.transport.server.ServerConnection;
import org.idoox.util.Base64;
import org.idoox.wasp.WaspSecurity;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.StopProcessingException;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.idoox.wasp.security.http.digest.HttpDigestConfig;
import org.systinet.monitoring.Event;
import org.systinet.monitoring.EventManager;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ServerInterceptor
implements TransportInterceptor {
    private static final Category log = Category.getCategory((String)"com.idoox.wasp.security.http.digest.ServerInterceptor");
    private static Hashtable contexts = new Hashtable(11, 0.75f);
    private static Object CONTEXT_SYNC = new Object();
    private static CleanerThread cleanerThread = null;
    private static ProviderConfiguration conf = new ProviderConfiguration();

    public void intercept(Connection connection, InterceptorChain chain, int position) throws IOException, StopProcessingException {
        this.initCleanerThread();
        ServerConnection serverConnection = (ServerConnection)connection;
        String credentials = connection.getInputMessage().getStringHeader("Authorization");
        String peer = connection.getInputMessage().getStringHeader("User-Agent");
        if (credentials == null) {
            this.initAuthenticate(connection, false, 401);
        }
        AuthorizationStructureImpl author = new AuthorizationStructureImpl(credentials, peer);
        author.setMethod(connection.getMethod().toString());
        Context context = null;
        if (author.getNonce() != null) {
            Object object = CONTEXT_SYNC;
            synchronized (object) {
                context = (Context)contexts.get(author.getNonce());
            }
        }
        if (context == null) {
            this.initAuthenticate(connection, true, 401);
        }
        context.access();
        this.authenticate(connection, context, author);
        try {
            WaspCallbackHandler handler = new WaspCallbackHandler((AuthorizationStructure)author, PStore.getInstance((String)"").getUserStore());
            ReceivedCredentialsImpl recCred = new ReceivedCredentialsImpl(author.getUsername(), "HttpDigest", "NameDigestAN", (CallbackHandler)handler);
            org.idoox.security.server.Current current = org.idoox.security.server.Current.getInstance();
            current.setReceivedCredentials((ReceivedCredentials)recCred);
            EventManager.fireEvent((Event)new LogEventAuthSuccess(author.getUsername(), "HttpDigest", serverConnection.getClientAddress(), connection.getURI().toExternalForm()));
        }
        catch (BadPasswordException e) {
            throw new RuntimeException("cannot authenticate user: " + author.getUsername() + ", bad password exception");
        }
        catch (RuntimeWrappedException e) {
            if (e.getException() instanceof LoginException) {
                EventManager.fireEvent((Event)new LogEventAuthFailed(author.getUsername(), "HttpDigest", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
                this.initAuthenticate(connection, true, 401);
            }
            throw e;
        }
        String auth = context.authen.toString();
        connection.getOutputMessage().setStringHeader("WWW-Authenticate", auth);
    }

    public void load(Configurable config) {
    }

    private final void initCleanerThread() {
        if (cleanerThread == null) {
            conf.refresh();
            if (ServerInterceptor.conf.sweepInterval > 0L) {
                cleanerThread = new CleanerThread();
                Timer timer = (Timer)org.idoox.wasp.Context.getInstance((String)"java.util.Timer");
                timer.schedule((TimerTask)cleanerThread, ServerInterceptor.conf.sweepInterval * 1000L, ServerInterceptor.conf.sweepInterval * 1000L);
            }
        }
    }

    public void destroy() {
    }

    private void initAuthenticate(Connection connection, boolean isStale, int statusCode) throws StopProcessingException {
        AuthenticateStructure authen = new AuthenticateStructure();
        this.resetAuthenticate(authen, connection, isStale);
        Object object = CONTEXT_SYNC;
        synchronized (object) {
            contexts.put(authen.nonce, new Context(authen));
        }
        this.sendChallenge(connection, authen, statusCode);
        ServiceManagerImpl.faultGenerated.set(Boolean.TRUE);
        throw new StopProcessingException();
    }

    private void resetAuthenticate(AuthenticateStructure authen, Connection connection, boolean isStale) {
        authen.domain = connection.getURI().toExternalForm();
        authen.realm = "HttpDigestAuthentication " + connection.getURI().toExternalForm();
        try {
            authen.nonce = String.valueOf(Calendar.getInstance().getTime().getTime());
            authen.nonce = new String(Base64.encode((byte[])authen.nonce.getBytes(Constants.UTF_8), (boolean)false), Constants.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        authen.opaque = Long.toHexString(System.currentTimeMillis());
        if (isStale) {
            authen.stalePresent = true;
            authen.stale = true;
        }
        conf.refresh();
        authen.algorithm = ServerInterceptor.conf.secAlgorithm;
        authen.qop = ServerInterceptor.conf.secQop;
    }

    private void sendChallenge(Connection connection, AuthenticateStructure authen, int statusCode) {
        OutputMessage omsg = connection.getOutputMessage();
        omsg.setStatusCode(statusCode);
        omsg.setStringHeader("WWW-Authenticate", authen.toString());
        try {
            omsg.flush();
            omsg.close();
        }
        catch (IOException e) {
            log.error("IOException when sending challenge, connection: " + connection.getURI().toExternalForm());
        }
    }

    private void authenticate(Connection connection, Context context, AuthorizationStructureImpl author) throws StopProcessingException {
        if (!context.authen.opaque.equals(author.getOpaque())) {
            this.initAuthenticate(connection, false, 401);
        }
        if (author.getQop() != null) {
            int nonceCount = -1;
            try {
                nonceCount = Integer.parseInt(author.getNc(), 16);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (context.nonceCount != nonceCount) {
                this.initAuthenticate(connection, false, 401);
            }
        }
        String serverLocation = null;
        try {
            serverLocation = new Endpoint(connection.getURI().toExternalForm()).getLocation();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!author.getUri().equals(serverLocation)) {
            this.initAuthenticate(connection, false, 400);
        }
    }

    static class ProviderConfiguration {
        long TTL = 600L;
        long sweepInterval = 180L;
        String secAlgorithm = null;
        String secQop = null;
        static /* synthetic */ Class class$org$idoox$wasp$security$http$digest$HttpDigestConfig;

        ProviderConfiguration() {
        }

        public void refresh() {
            Configurable configurable = null;
            HttpDigestConfig config = null;
            ServiceEndpointContext seCtx = Current.getServiceEndpointContext();
            configurable = WaspSecurity.getProviderProperties((ServiceEndpointContext)seCtx, (String)"HttpDigest");
            if (configurable != null && (config = (HttpDigestConfig)configurable.narrow(class$org$idoox$wasp$security$http$digest$HttpDigestConfig == null ? (class$org$idoox$wasp$security$http$digest$HttpDigestConfig = ProviderConfiguration.class$("org.idoox.wasp.security.http.digest.HttpDigestConfig")) : class$org$idoox$wasp$security$http$digest$HttpDigestConfig)) != null) {
                try {
                    this.secAlgorithm = config.getAlgorithm();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.secQop = config.getQop();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.TTL = config.getContextTTL();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.sweepInterval = config.getSweepInterval();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class CleanerThread
    extends TimerTask {
        CleanerThread() {
        }

        public void run() {
            Object object = CONTEXT_SYNC;
            synchronized (object) {
                Set entrySet = contexts.entrySet();
                Iterator it = entrySet.iterator();
                long currentTime = System.currentTimeMillis() / 1000L;
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Context data = (Context)entry.getValue();
                    if (data.expiredTime > currentTime) continue;
                    entrySet.remove(entry);
                }
            }
        }
    }

    static class Context {
        AuthenticateStructure authen = null;
        int nonceCount = -1;
        long expiredTime = 0L;

        public Context(AuthenticateStructure authen) {
            this.authen = authen;
            this.access();
        }

        public void access() {
            ++this.nonceCount;
            this.expiredTime = System.currentTimeMillis() + conf.TTL;
        }
    }
}

