/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.client;

import com.idoox.debug.Category;
import com.idoox.wasp.config.SecurityModuleConfig;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.client.Current;
import org.idoox.security.spi.ClientSecurityProvider;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;

public class CurrentImpl
extends Current {
    private static final Category dbg = Category.getCategory((String)"security.client");
    private Credentials[] creds;
    private ThreadLocal threadCreds = new ThreadLocal();
    private Provider currentProvider;
    private String[] providerNames;
    private HashMap providers = new HashMap(11, 0.75f);
    static /* synthetic */ Class class$com$idoox$wasp$config$SecurityModuleConfig;

    public CurrentImpl() {
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable c = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
        if (c == null) {
            dbg.warn("Cannot find security module configuration, no default security providers will be available");
            return;
        }
        SecurityModuleConfig config = (SecurityModuleConfig)c.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = CurrentImpl.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
        SecurityModuleConfig.SecurityProvider[] providers = config.getSecurityProviders();
        if (providers == null || providers.length == 0) {
            dbg.warn("No security providers configured");
            return;
        }
        int i = 0;
        while (i < providers.length) {
            Provider p = new Provider(providers[i].getProviderName(), providers[i].getProviderClass());
            this.providers.put(p.name, p);
            ++i;
        }
        this.providerNames = new String[this.providers.size()];
        Iterator keys = this.providers.keySet().iterator();
        int i2 = 0;
        while (keys.hasNext()) {
            this.providerNames[i2++] = (String)keys.next();
        }
        String providerName = config.getInitiatingSecurityProvider();
        if (providerName != null) {
            this.currentProvider = (Provider)this.providers.get(providerName);
            if (this.currentProvider == null) {
                dbg.warn("Invalid name of the default provider: " + providerName);
            }
            try {
                this.currentProvider.getInstance().setCurrent(null);
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeWrappedException((Throwable)e);
            }
        } else {
            dbg.info("No default security provider configured");
        }
    }

    public void setCredentials(Credentials[] newCreds) {
        if (newCreds == null || newCreds.length == 0) {
            throw new IllegalArgumentException("New credentials cannot be null or empty.");
        }
        if (this.creds == null) {
            this.creds = newCreds;
        } else {
            Credentials[] tmp = new Credentials[this.creds.length + newCreds.length];
            System.arraycopy(this.creds, 0, tmp, 0, this.creds.length);
            System.arraycopy(newCreds, 0, tmp, this.creds.length, newCreds.length);
            this.creds = tmp;
        }
    }

    public void setCredentials(Credentials[] newCreds, Map parameters) {
        if (newCreds == null || newCreds.length == 0) {
            throw new IllegalArgumentException("New credentials cannot be null or empty.");
        }
        if (this.creds == null) {
            this.creds = newCreds;
        } else {
            Credentials[] tmp = new Credentials[this.creds.length + newCreds.length];
            System.arraycopy(this.creds, 0, tmp, 0, this.creds.length);
            System.arraycopy(newCreds, 0, tmp, this.creds.length, newCreds.length);
            this.creds = tmp;
        }
    }

    public void setCurrentThreadCredentials(Credentials[] creds) {
        Credentials[] current = (Credentials[])this.threadCreds.get();
        if (current == null || creds == null) {
            this.threadCreds.set(creds);
        } else {
            Credentials[] tmp = new Credentials[current.length + creds.length];
            System.arraycopy(current, 0, tmp, 0, current.length);
            System.arraycopy(creds, 0, tmp, current.length, creds.length);
            this.threadCreds.set(tmp);
        }
    }

    public Credentials[] getCredentials() {
        Credentials[] retval = (Credentials[])this.threadCreds.get();
        if (retval == null) {
            retval = this.creds;
        }
        return retval;
    }

    public PrincipalAuthenticator getAuthenticator(String provider) throws NoSuchProviderException {
        Provider p = (Provider)this.providers.get(provider);
        if (p == null) {
            throw new NoSuchProviderException("Security provider " + provider + " not found");
        }
        ClientSecurityProvider pr = p.getInstance();
        return pr.getAuthenticator();
    }

    public PrincipalAuthenticator getAuthenticator() {
        try {
            if (this.currentProvider == null) {
                throw new RuntimeException("No default provider configured");
            }
            ClientSecurityProvider p = this.currentProvider.getInstance();
            return p.getAuthenticator();
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void resetCredentials() {
        this.creds = null;
        if (this.currentProvider != null) {
            try {
                this.currentProvider.getInstance().resetContexts(null);
            }
            catch (Exception e) {
                throw new RuntimeWrappedException((Throwable)e);
            }
        }
    }

    public String[] getProviders() {
        return this.providerNames;
    }

    public void registerProvider(String name, String implClassName) {
        if (this.providers.containsKey(name)) {
            throw new RuntimeException("Provider " + name + " already registered");
        }
        String[] tmp = new String[this.providerNames.length + 1];
        System.arraycopy(this.providerNames, 0, tmp, 0, this.providerNames.length);
        tmp[tmp.length - 1] = name;
        this.providers.put(name, new Provider(name, implClassName));
    }

    public Properties getProviderProperties(String name) throws NoSuchProviderException {
        Provider p = (Provider)this.providers.get(name);
        if (p == null) {
            throw new NoSuchProviderException("Provider " + name + " cannot be found");
        }
        return p.getInstance().getProperties();
    }

    public String getCurrentProvider() {
        if (this.currentProvider == null) {
            throw new RuntimeException("No default provider configured");
        }
        return this.currentProvider.name;
    }

    public void setCurrentProvider(String name) throws NoSuchProviderException {
        Provider p = null;
        if (name != null && (p = (Provider)this.providers.get(name)) == null) {
            throw new NoSuchProviderException("Provider " + name + " not found");
        }
        if (this.currentProvider != null) {
            this.currentProvider.getInstance().unsetCurrent(null);
        }
        this.currentProvider = p;
        if (this.currentProvider != null) {
            this.currentProvider.getInstance().setCurrent(null);
        }
    }

    public void setCurrentProvider(String name, Map parameters) throws NoSuchProviderException {
        Provider p = null;
        if (name != null && (p = (Provider)this.providers.get(name)) == null) {
            throw new NoSuchProviderException("Provider " + name + " not found");
        }
        if (this.currentProvider != null) {
            this.currentProvider.getInstance().unsetCurrent(parameters);
        }
        this.currentProvider = p;
        if (this.currentProvider != null) {
            this.currentProvider.getInstance().setCurrent(parameters);
        }
    }

    public ClientSecurityProvider getProvider(String name) throws NoSuchProviderException {
        Provider p = (Provider)this.providers.get(name);
        if (p == null) {
            throw new NoSuchProviderException("Provider " + name + " not found");
        }
        return p.getInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Provider {
        String name;
        String className;
        ClientSecurityProvider instance;

        Provider(String name, String className) {
            this.name = name;
            this.className = className;
        }

        ClientSecurityProvider getInstance() throws NoSuchProviderException {
            if (this.instance == null) {
                Provider provider = this;
                synchronized (provider) {
                    if (this.instance != null) {
                        ClientSecurityProvider clientSecurityProvider = this.instance;
                        return clientSecurityProvider;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.className);
                        this.instance = (ClientSecurityProvider)clazz.newInstance();
                    }
                    catch (Exception e) {
                        throw new NoSuchProviderException(e.getMessage());
                    }
                }
            }
            return this.instance;
        }
    }
}

