/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.ca;

import com.idoox.debug.Category;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.pkcs.CertificationRequest;
import com.idoox.security.x509.Certificate;
import com.idoox.security.x509.SubjectPublicKeyInfo;
import com.idoox.security.x509.TBSCertificate;
import com.idoox.security.x509.Validity;
import com.idoox.security.x509.X500Name;
import com.idoox.wasp.security.ca.CAConfig;
import com.idoox.wasp.security.ca.CAException;
import com.idoox.wasp.security.ca.CAIface;
import com.idoox.wasp.security.ca.DBException;
import com.idoox.wasp.security.ca.Database;
import com.idoox.wasp.security.ca.SignaturePOP;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.idoox.config.Configurable;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.PStore;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.webservice.server.Initializable;
import org.idoox.webservice.server.WebServiceContext;

public class CAImpl
implements Initializable,
CAIface {
    private static final int CERTIFICATE_VALIDITY = 365;
    private static final String SIG_ALG_NAME = "MD5WithRSA";
    private static final Category dbg = Category.getCategory((String)"com.idoox.wasp.security.ca.CAImpl");
    private Database db;
    private PrivateKey caKey;
    private X500Name caName;
    static /* synthetic */ Class class$com$idoox$wasp$security$ca$CAConfig;

    public void init(WebServiceContext serviceContext) {
        String caPassword;
        URL rootPath;
        Configurable c = serviceContext.getServiceConfigurable();
        CAConfig config = (CAConfig)c.narrow(class$com$idoox$wasp$security$ca$CAConfig == null ? (class$com$idoox$wasp$security$ca$CAConfig = CAImpl.class$("com.idoox.wasp.security.ca.CAConfig")) : class$com$idoox$wasp$security$ca$CAConfig);
        String path = config.getCaWorkDir();
        try {
            rootPath = new URL(serviceContext.getRootPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot get service root path");
        }
        path = path == null ? rootPath.getFile() + "ca/" : rootPath.getFile() + path;
        this.db = new Database(path);
        String caAlias = config.getCaAlias();
        if (caAlias == null) {
            caAlias = "CA";
        }
        if ((caPassword = config.getCaPassword()) == null) {
            caPassword = "abcd";
        }
        try {
            PStore pstore = PStore.getInstance(null);
            KeyStore keyStore = pstore.getKeyStore();
            if (!keyStore.containsAlias(caAlias)) {
                dbg.error("Protected store entry '" + caAlias + "' does not " + "exists, CA will not be able to issue certificates");
                return;
            }
            this.caKey = (PrivateKey)keyStore.getKey(caAlias, caPassword);
            X509Certificate caCert = (X509Certificate)keyStore.getCertificateChain(caAlias)[0];
            Certificate cert = new Certificate(caCert.getEncoded());
            this.caName = cert.getTBSCertificate().getSubject();
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Cannot get CA private key", (Throwable)e);
        }
    }

    public void destroy() {
    }

    public byte[] requestCertificate(byte[] request) throws CAException {
        if (this.caKey == null) {
            throw new CAException("Cannot issue certificates");
        }
        try {
            CertificationRequest req = new CertificationRequest(request);
            X500Name subj = req.getRequestInfo().getSubject();
            if (this.db.containsSubject(subj)) {
                throw new CAException("A Certificate for the requested subject name was already issued");
            }
            X509Certificate cert = this.generateCertificate(req);
            this.db.storeCertificate(subj, cert, false);
            return cert.getEncoded();
        }
        catch (Asn1Exception e) {
            throw new CAException(e.getMessage());
        }
        catch (DBException e) {
            throw new CAException(e.getMessage());
        }
        catch (CertificateEncodingException e) {
            throw new CAException(e.getMessage());
        }
    }

    public byte[] updateKey(byte[] request, byte[] signaturePOP) throws CAException {
        if (this.caKey == null) {
            throw new CAException("Cannot issue certificate updates");
        }
        try {
            CertificationRequest req = new CertificationRequest(request);
            X500Name subj = req.getRequestInfo().getSubject();
            if (!this.db.containsSubject(subj)) {
                throw new CAException("No certificate for requested subject name was issued");
            }
            X509Certificate oldCert = this.db.getCertificate(subj);
            SignaturePOP pop = new SignaturePOP(signaturePOP);
            Signature sig = Signature.getInstance(pop.getSigAlgName());
            sig.initVerify(oldCert.getPublicKey());
            sig.update(req.encode());
            if (!sig.verify(pop.getSignature())) {
                throw new CAException("Invalid signature in proof of possession parameter");
            }
            X509Certificate newCert = this.generateCertificate(req);
            this.db.storeCertificate(subj, newCert, true);
            return newCert.getEncoded();
        }
        catch (Asn1Exception e) {
            throw new CAException(e.getMessage());
        }
        catch (DBException e) {
            throw new CAException(e.getMessage());
        }
        catch (CertificateEncodingException e) {
            throw new CAException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new CAException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CAException(e.getMessage());
        }
        catch (SignatureException e) {
            throw new CAException(e.getMessage());
        }
    }

    private X509Certificate generateCertificate(CertificationRequest request) throws CAException {
        X500Name subject = request.getRequestInfo().getSubject();
        SubjectPublicKeyInfo spki = request.getRequestInfo().getSubjectPKInfo();
        Validity validity = new Validity(365);
        TBSCertificate tbsCert = new TBSCertificate(0, BigInteger.valueOf(System.currentTimeMillis()), SIG_ALG_NAME, this.caName, validity, subject, spki, null, null, null);
        Certificate cert = new Certificate(tbsCert, this.caKey);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            ByteArrayInputStream bin = new ByteArrayInputStream(cert.encode());
            return (X509Certificate)cf.generateCertificate(bin);
        }
        catch (CertificateException e) {
            throw new CAException("Cannot generate requested certificate");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

