/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.https.impl;

import com.idoox.security.util.CertUtil;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.idoox.security.pstore.AliasEntry;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.PStore;
import org.idoox.util.RuntimeWrappedException;

public class X509TrustManagerBase {
    public X509Certificate[] getAcceptedIssuers() {
        try {
            KeyStore keyStore = PStore.getInstance(null).getKeyStore();
            AliasEntry[] entries = keyStore.getAliasEntries();
            if (entries == null || entries.length == 0) {
                return new X509Certificate[0];
            }
            ArrayList<Certificate> retval = new ArrayList<Certificate>(entries.length);
            int i = 0;
            while (i < entries.length) {
                AliasEntry entry = entries[i];
                if (entry.getEntryType() == 2) {
                    Certificate[] certs = keyStore.getCertificateChain(entry.getAlias());
                    int j = 0;
                    while (j < certs.length) {
                        if (certs[j] instanceof X509Certificate) {
                            retval.add(certs[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return retval.toArray(new X509Certificate[0]);
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("getAcceptedIssuers error. " + (e.getMessage() != null ? e.getMessage() : ""), (Throwable)e);
        }
    }

    public boolean isClientTrusted(X509Certificate[] chain) {
        return CertUtil.IsCertChainTrusted((Certificate[])chain);
    }

    public boolean isServerTrusted(X509Certificate[] chain) {
        boolean trusted = CertUtil.IsCertChainTrusted((Certificate[])chain);
        return trusted;
    }
}

