/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.security.util.PBEWithSHAAnd3_KeyTripleDES_CBC;
import com.idoox.security.util.Random;
import com.idoox.wasp.Constants;
import java.io.UnsupportedEncodingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.idoox.util.Base64;
import org.idoox.util.RuntimeWrappedException;

public class CryptTools {
    private PBEWithSHAAnd3_KeyTripleDES_CBC cipher;
    private byte[] salt;
    String password = "";
    private SecretKey secretKey;
    private IvParameterSpec ivSpec;

    public byte[] encryptBytes(byte[] plain) {
        if (this.cipher == null) {
            return plain;
        }
        return this.encrypt(plain);
    }

    public byte[] decryptBytes(byte[] encrypted) {
        if (this.cipher == null) {
            return encrypted;
        }
        return this.decrypt(encrypted);
    }

    public String encryptString(String plain) {
        if (this.cipher == null) {
            return plain;
        }
        try {
            byte[] encrypted = Base64.encode((byte[])this.encrypt(plain.getBytes(Constants.UTF_8)), (boolean)false);
            return new String(encrypted, Constants.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String decryptString(String encrypted) {
        if (this.cipher == null) {
            return encrypted;
        }
        try {
            byte[] plain = this.decrypt(Base64.decode((byte[])encrypted.getBytes(Constants.UTF_8)));
            return new String(plain, Constants.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    private byte[] encrypt(byte[] data) {
        try {
            Cipher c = this.cipher.init(1, this.secretKey, this.ivSpec);
            return c.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Data encryption failed", (Throwable)e);
        }
    }

    private byte[] decrypt(byte[] data) {
        try {
            Cipher c = this.cipher.init(2, this.secretKey, this.ivSpec);
            return c.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Data decryption failed", (Throwable)e);
        }
    }

    public CryptTools(String password, byte[] salt) {
        if (password == null || "".equals(password)) {
            return;
        }
        this.password = password;
        this.cipher = new PBEWithSHAAnd3_KeyTripleDES_CBC();
        this.setSalt(salt);
    }

    public byte[] setSalt(byte[] salt) {
        this.salt = salt;
        if (this.salt == null) {
            this.salt = new byte[8];
            Random.getRandom().nextBytes(this.salt);
        }
        this.secretKey = this.cipher.getKey(this.password, this.salt, 1024);
        this.ivSpec = this.cipher.getIvSpec(this.password, this.salt, 1024);
        return this.salt;
    }

    public byte[] getSalt() {
        return this.salt;
    }
}

