/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.policy;

import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import org.systinet.security.policy.PrincipalEntries;
import org.systinet.security.policy.UpdateablePolicy;

public class Policy2UpdateablePolicy
extends UpdateablePolicy {
    private Policy policy;
    private UpdateablePolicy nestedPolicy;
    private boolean isUpdatable;

    public Policy2UpdateablePolicy(Map initParams) {
        this(Policy.getPolicy());
    }

    public Policy2UpdateablePolicy(Policy policy) {
        super(null);
        this.policy = policy;
        this.isUpdatable = policy instanceof UpdateablePolicy;
        if (this.isUpdatable) {
            this.nestedPolicy = (UpdateablePolicy)policy;
            this.isUpdatable = this.nestedPolicy.isUpdatable();
        } else {
            this.nestedPolicy = null;
        }
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public boolean isRoleManager() {
        if (this.isUpdatable) {
            return this.nestedPolicy.isRoleManager();
        }
        return false;
    }

    public void refresh() {
        this.policy.refresh();
    }

    public PermissionCollection getPermissions(Subject subject, CodeSource codesource) {
        return this.policy.getPermissions(subject, codesource);
    }

    public void addPermissions(CodeSource cs, Principal principal, PermissionCollection collection) throws AccessControlException {
        if (!this.isUpdatable) {
            throw new AccessControlException("Security policy is read only");
        }
        this.nestedPolicy.addPermissions(cs, principal, collection);
    }

    public boolean addPermission(CodeSource cs, Principal principal, Permission permission) throws AccessControlException {
        if (this.isUpdatable) {
            return this.nestedPolicy.addPermission(cs, principal, permission);
        }
        throw new AccessControlException("Security policy is read only");
    }

    public boolean removePermission(CodeSource cs, Principal principal, Permission permission) throws AccessControlException {
        if (this.isUpdatable) {
            return this.nestedPolicy.removePermission(cs, principal, permission);
        }
        throw new AccessControlException("Security policy is read only");
    }

    public PermissionCollection getPrincipalPermissions(CodeSource cs, Principal principal) throws AccessControlException {
        if (this.isUpdatable) {
            return this.nestedPolicy.getPrincipalPermissions(cs, principal);
        }
        throw new AccessControlException("Security policy is read only");
    }

    public PermissionCollection getPrincipalPermissions(CodeSource cs, Principal principal, boolean roleInheritted) throws AccessControlException {
        if (this.isUpdatable) {
            return this.nestedPolicy.getPrincipalPermissions(cs, principal, roleInheritted);
        }
        throw new AccessControlException("Security policy is read only");
    }

    public PrincipalEntries getPrincipalEntries() throws AccessControlException {
        if (this.isUpdatable) {
            return this.nestedPolicy.getPrincipalEntries();
        }
        throw new AccessControlException("Security policy is read only");
    }

    public PrincipalEntries getPrincipalEntries(Permission perm) throws AccessControlException {
        if (this.isUpdatable) {
            return this.nestedPolicy.getPrincipalEntries(perm);
        }
        throw new AccessControlException("Security policy is read only");
    }

    public Iterator getRoleNames() {
        if (this.isUpdatable) {
            return this.nestedPolicy.getRoleNames();
        }
        throw new AccessControlException("Security policy cannot manage roles");
    }

    public boolean addPermissionToRole(String roleName, Permission permission) {
        if (this.isUpdatable) {
            return this.nestedPolicy.addPermissionToRole(roleName, permission);
        }
        throw new AccessControlException("Security policy cannot manage roles");
    }

    public boolean removePermissionFromRole(String roleName, Permission permission) {
        if (this.isUpdatable) {
            return this.nestedPolicy.removePermissionFromRole(roleName, permission);
        }
        throw new AccessControlException("Security policy cannot manage roles");
    }

    public PermissionCollection getRolePermissions(String roleName) {
        if (this.isUpdatable) {
            return this.nestedPolicy.getRolePermissions(roleName);
        }
        throw new AccessControlException("Security policy cannot manage roles");
    }
}

