/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.policy;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import org.systinet.security.policy.WASPAccessController;

public final class JAASAccessController
extends WASPAccessController {
    public JAASAccessController(Map properties) {
        super(properties);
    }

    public void checkPermission(Subject subject, Permission perm) throws AccessControlException {
        if (subject == null) {
            AccessController.checkPermission(perm);
            return;
        }
        try {
            Subject.doAs(subject, new AccessControlPrivilegedAction(perm));
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex != null) {
                if (ex instanceof AccessControlException) {
                    throw (AccessControlException)ex.fillInStackTrace();
                }
                throw new AccessControlException(ex.getMessage(), perm);
            }
            throw new AccessControlException("Unsufficient permissions of the caller. Detail:" + e.getMessage(), perm);
        }
        catch (SecurityException e) {
            throw new AccessControlException("Unable to perform Subject.doAs() action.");
        }
    }

    private static class AccessControlPrivilegedAction
    implements PrivilegedExceptionAction {
        Permission perm;

        AccessControlPrivilegedAction(Permission perm) {
            this.perm = perm;
        }

        public Object run() throws Exception {
            AccessController.checkPermission(this.perm);
            return null;
        }
    }
}

