/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import org.systinet.security.perm.WSManagePermission;
import org.systinet.security.perm.WSStatePermissionCollection;

public final class WSStatePermission
extends WSManagePermission {
    public static final int ENABLE = 1;
    public static final int DISABLE = 2;
    public static final int GET = 4;
    public static final int START = 8;
    public static final int STOP = 16;
    public static final int ALL = 31;
    private static final int NONE = 0;
    private static final int[] ACTION_FLAGS = new int[]{1, 2, 4, 8, 16};
    private static final String[] ACTION_STRINGS = new String[]{"enable", "disable", "get", "start", "stop"};
    private transient int mask;
    private String actions;

    private void init(int mask) {
        if ((mask & 0x1F) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = mask;
    }

    public WSStatePermission(String name, String actions) {
        super(name);
        if (actions == null || actions.length() == 0) {
            this.mask = 31;
        } else {
            this.init(WSStatePermission.getMask(actions));
        }
    }

    public WSStatePermission(String name, int actionMask) {
        super(name);
        this.init(actionMask);
    }

    public boolean implies(Permission p) {
        if (!(p instanceof WSStatePermission)) {
            return false;
        }
        WSStatePermission that = (WSStatePermission)p;
        if ((this.mask & that.mask) == that.mask) {
            if (this.getName().equals("*")) {
                return true;
            }
            return this.getName().equals(that.getName());
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WSStatePermission)) {
            return false;
        }
        WSStatePermission that = (WSStatePermission)obj;
        return this.mask == that.mask && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String actions) {
        mask = 0;
        if (actions == null) {
            return mask;
        }
        a = actions.toCharArray();
        i = a.length - 1;
        if (i >= 0) ** GOTO lbl44
        return mask;
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (!(i < 5 || a[i - 5] != 'e' && a[i - 5] != 'E' || a[i - 4] != 'n' && a[i - 4] != 'N' || a[i - 3] != 'a' && a[i - 3] != 'A' || a[i - 2] != 'b' && a[i - 2] != 'B' || a[i - 1] != 'l' && a[i - 1] != 'L' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 6;
                    mask |= 1;
                } else if (!(i < 6 || a[i - 6] != 'd' && a[i - 6] != 'D' || a[i - 5] != 'i' && a[i - 5] != 'I' || a[i - 4] != 's' && a[i - 4] != 'S' || a[i - 3] != 'a' && a[i - 3] != 'A' || a[i - 2] != 'b' && a[i - 2] != 'B' || a[i - 1] != 'l' && a[i - 1] != 'L' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 7;
                    mask |= 2;
                } else if (!(i < 2 || a[i - 2] != 'g' && a[i - 2] != 'G' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 3;
                    mask |= 4;
                } else if (!(i < 4 || a[i - 4] != 's' && a[i - 4] != 'S' || a[i - 3] != 't' && a[i - 3] != 'T' || a[i - 2] != 'a' && a[i - 2] != 'A' || a[i - 1] != 'r' && a[i - 1] != 'R' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 5;
                    mask |= 8;
                } else if (!(i < 3 || a[i - 3] != 's' && a[i - 3] != 'S' || a[i - 2] != 't' && a[i - 2] != 'T' || a[i - 1] != 'o' && a[i - 1] != 'O' || a[i] != 'p' && a[i] != 'P')) {
                    matchlen = 4;
                    mask |= 16;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + actions);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + actions);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl44:
                // 2 sources

            } while (i != -1);
        }
        return mask;
    }

    static String getActions(int mask) {
        StringBuffer sb = new StringBuffer();
        boolean nc = false;
        int i = 0;
        while (i < ACTION_FLAGS.length) {
            if ((mask & ACTION_FLAGS[i]) > 0) {
                if (nc) {
                    sb.append(',');
                }
                sb.append(ACTION_STRINGS[i]);
                nc = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = WSStatePermission.getActions(this.mask);
        }
        return this.actions;
    }

    int getMask() {
        return this.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new WSStatePermissionCollection();
    }
}

