/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.systinet.security.perm.WSManagePermission;

final class WSManagePermissionCollection
extends PermissionCollection {
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof WSManagePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        WSManagePermission pp = (WSManagePermission)permission;
        WSManagePermission existing = (WSManagePermission)this.permissions.get(pp.getName());
        if (existing != null) {
            int newMask;
            int oldMask = existing.getMask();
            int effective = oldMask | (newMask = pp.getMask());
            if (effective != oldMask) {
                this.permissions.put(pp.getName(), new WSManagePermission(pp.getName(), effective));
            }
        } else {
            this.permissions.put(pp.getName(), permission);
        }
        if (!this.all_allowed && pp.getName().equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        WSManagePermission x;
        if (!(permission instanceof WSManagePermission)) {
            return false;
        }
        WSManagePermission pp = (WSManagePermission)permission;
        int desired = pp.getMask();
        int effective = 0;
        String name = pp.getName();
        if (this.all_allowed) {
            x = (WSManagePermission)this.permissions.get("*");
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            if (name.equals("*")) {
                return false;
            }
        }
        return (x = (WSManagePermission)this.permissions.get(name)) != null && ((effective |= x.getMask()) & desired) == desired;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

