/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.systinet.security.perm.WASPUndeployPermission;

final class WASPUndeployPermissionCollection
extends PermissionCollection {
    private boolean isAll;
    private Hashtable permissions = new Hashtable();

    public void add(Permission permission) {
        if (!(permission instanceof WASPUndeployPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        WASPUndeployPermission that = (WASPUndeployPermission)permission;
        this.permissions.put(permission.getName(), permission);
        if (!this.isAll && permission.getName().equals("*")) {
            this.isAll = true;
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof WASPUndeployPermission)) {
            return false;
        }
        WASPUndeployPermission that = (WASPUndeployPermission)permission;
        if (this.isAll) {
            return true;
        }
        return this.permissions.get(permission.getName()) != null;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

