/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import org.systinet.security.perm.WASPDeployPermission;

public final class WASPDeployPermissionCollection
extends PermissionCollection {
    private Vector deployPermissions = null;
    private int deployPermissionMask = 0;
    private static Enumeration NONE_DEPLOY_PERMS = new Vector(0).elements();

    public void add(Permission permission) {
        if (!(permission instanceof WASPDeployPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        WASPDeployPermission addedPermission = (WASPDeployPermission)permission;
        WASPDeployPermissionCollection wASPDeployPermissionCollection = this;
        synchronized (wASPDeployPermissionCollection) {
            if (this.deployPermissions == null) {
                this.deployPermissions = new Vector(3);
            }
            this.deployPermissions.add(addedPermission);
            this.deployPermissionMask |= addedPermission.mask;
        }
    }

    public boolean implies(Permission permission) {
        WASPDeployPermissionCollection wASPDeployPermissionCollection = this;
        synchronized (wASPDeployPermissionCollection) {
            if (permission == null || this.deployPermissions == null || !(permission instanceof WASPDeployPermission)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = (this.deployPermissionMask & ((WASPDeployPermission)permission).mask) == ((WASPDeployPermission)permission).mask;
            return bl;
        }
    }

    public Enumeration elements() {
        WASPDeployPermissionCollection wASPDeployPermissionCollection = this;
        synchronized (wASPDeployPermissionCollection) {
            Enumeration enumeration = this.deployPermissions != null ? this.deployPermissions.elements() : NONE_DEPLOY_PERMS;
            return enumeration;
        }
    }
}

