/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import org.systinet.security.perm.WASPDeployPermissionCollection;
import org.systinet.security.perm.WSManagePermission;

public final class WASPDeployPermission
extends WSManagePermission {
    public static final int MODULE = 1;
    public static final int WS = 0;
    public static final int TRANSPORT = 2;
    protected transient int mask;

    public WASPDeployPermission() {
        this.mask |= 0;
    }

    public WASPDeployPermission(String name) {
        String string;
        if (name != null) {
            name = name.toLowerCase();
            string = WASPDeployPermission.canonicalize(name);
        } else {
            string = "ws";
        }
        super(string);
        if (name == null) {
            this.mask |= 0;
            return;
        }
        this.mask = WASPDeployPermission.convertToNameMask(this.getName());
    }

    public WASPDeployPermission(int nameMask) {
        super(WASPDeployPermission.convertToNameString(nameMask));
        this.mask = nameMask;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" name='");
        sb.append(this.getName());
        sb.append("' action='");
        sb.append(this.getActions());
        sb.append('\'');
        return sb.toString();
    }

    public String getActions() {
        return null;
    }

    public boolean implies(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (!(permission instanceof WASPDeployPermission)) {
            return false;
        }
        WASPDeployPermission dp = (WASPDeployPermission)permission;
        return (dp.mask & this.mask) == dp.mask;
    }

    public int hashCode() {
        return this.mask;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WASPDeployPermission)) {
            return false;
        }
        WASPDeployPermission dp = (WASPDeployPermission)obj;
        return this.mask == dp.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new WASPDeployPermissionCollection();
    }

    public int getNameMask() {
        return this.mask;
    }

    private static final String convertToNameString(int nameMask) {
        String retVal;
        if (nameMask < 0 || nameMask > 3) {
            // empty if block
        }
        switch (nameMask) {
            case 0: {
                retVal = "ws";
                break;
            }
            case 2: {
                retVal = "ws,transport";
                break;
            }
            case 1: {
                retVal = "ws,module";
                break;
            }
            case 3: {
                retVal = "ws,transport,module";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid permission name mask: " + nameMask);
            }
        }
        return retVal;
    }

    /*
     * Unable to fully structure code
     */
    private static final int convertToNameMask(String name) {
        mask = 0;
        chars = name.toCharArray();
        i = chars.length - 1;
        ** GOTO lbl32
        {
            --i;
            do {
                if (i != -1 && ((c = chars[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (i >= 5 && chars[i - 5] == 'm' && chars[i - 4] == 'o' && chars[i - 3] == 'd' && chars[i - 2] == 'u' && chars[i - 1] == 'l' && chars[i] == 'e') {
                    mask |= 1;
                    i -= 6;
                } else if (i >= 8 && chars[i - 8] == 't' && chars[i - 7] == 'r' && chars[i - 6] == 'a' && chars[i - 5] == 'n' && chars[i - 4] == 's' && chars[i - 3] == 'p' && chars[i - 2] == 'o' && chars[i - 1] == 'r' && chars[i] == 't') {
                    mask |= 2;
                    i -= 9;
                } else if (i >= 1 && chars[i - 1] == 'w' && chars[i] == 's') {
                    mask |= 0;
                    i -= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission name: " + name);
                }
                seencomma = false;
                while (i != -1 && !seencomma) {
                    switch (chars[i]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission name: " + name);
                        }
                    }
                    --i;
                }
lbl32:
                // 2 sources

            } while (i != -1);
        }
        return mask;
    }

    private static final String canonicalize(String name) {
        int m = WASPDeployPermission.convertToNameMask(name);
        return WASPDeployPermission.convertToNameString(m);
    }
}

