/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.security.policy;

import java.security.AccessControlException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Map;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import org.systinet.security.policy.WASPAccessController;

public final class PolicyAccessController
extends WASPAccessController {
    private Policy policy;

    public PolicyAccessController(Map configurationParameters) {
        super(configurationParameters);
        this.policy = (Policy)configurationParameters.get("wasp.ac.policy.instance");
    }

    public PolicyAccessController(Policy policy) {
        super(null);
        this.policy = policy;
    }

    public void checkPermission(Subject subject, Permission perm) throws AccessControlException {
        if (this.policy == null) {
            throw new AccessControlException("There is no policy!");
        }
        PermissionCollection perms = this.policy.getPermissions(subject, null);
        if (!perms.implies(perm)) {
            throw new AccessControlException("Insufficient privileges, " + perm + " permission is required");
        }
    }
}

