/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.security.policy;

import com.idoox.debug.Category;
import com.systinet.security.policy.Acl;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.security.auth.Subject;
import org.idoox.security.WASPPrincipal;
import org.systinet.security.perm.WASPRole;
import org.systinet.security.perm.WSInvokePermission;
import org.systinet.security.policy.PrincipalEntries;

public class Acl2JavaAcl {
    private static final Category debug = Category.getCategory("com.systinet.security.policy.Acl2JavaAcl");
    private static final Object NO_PRINC = new Object();
    private static final Class[] STR_ARR1 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Acl2JavaAcl.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] STR_ARR2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Acl2JavaAcl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Acl2JavaAcl.class$("java.lang.String")) : class$java$lang$String};
    Map princMap = null;
    Map roleMap = null;
    Acl acl = null;
    static /* synthetic */ Class class$java$lang$String;

    public Acl2JavaAcl(Acl acl) {
        this.init(acl);
    }

    private void init(Acl acl) {
        Acl.Role[] roles;
        this.princMap = new HashMap(89);
        this.roleMap = new HashMap(11);
        this.acl = acl;
        Acl.Grant[] grants = acl.getGrant();
        if (grants != null) {
            int i = 0;
            while (i < grants.length) {
                block28: {
                    Acl.Princ gpr = grants[i].getPrinc();
                    GrantEntry ge = null;
                    if (gpr == null) {
                        Object o = this.princMap.get(NO_PRINC);
                        if (o == null) {
                            ge = new GrantEntry();
                            this.princMap.put(NO_PRINC, ge);
                        } else {
                            ge = (GrantEntry)o;
                        }
                    } else {
                        String className = gpr.getClazz().intern();
                        String name = gpr.getN();
                        Object princ = null;
                        try {
                            if (className == "org.idoox.security.WASPPrincipal") {
                                if (name == null) {
                                    throw new Exception("WASPPrincipal requires its name to be present!");
                                }
                                princ = new WASPPrincipal(name);
                            } else {
                                Class<?> c = Class.forName(className);
                                Constructor<?> constr = c.getConstructor(STR_ARR1);
                                princ = (Principal)constr.newInstance(name);
                            }
                        }
                        catch (Exception e) {
                            debug.error("Cannot instantiate principal class!", e);
                            break block28;
                        }
                        Object o = this.princMap.get(princ);
                        if (o == null) {
                            ge = new GrantEntry((Principal)princ);
                            this.princMap.put(princ, ge);
                        } else {
                            ge = (GrantEntry)o;
                        }
                    }
                    Acl.Perm[] perms = grants[i].getPerm();
                    if (perms != null) {
                        int j = 0;
                        while (j < perms.length) {
                            String actions;
                            Acl.Perm perm = perms[j];
                            String className = perm.getClazz().intern();
                            String name = perm.getN();
                            if (name != null && name.length() == 0) {
                                name = null;
                            }
                            if ((actions = perm.getActions()) != null && actions.length() == 0) {
                                actions = null;
                            }
                            Permission permission = null;
                            try {
                                permission = Acl2JavaAcl.getPermission(className, name, actions);
                                ge.addPermission(permission);
                            }
                            catch (Exception e) {
                                debug.error("Cannot instantiate permission class!", e);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if ((roles = acl.getRole()) != null) {
            int i = 0;
            while (i < roles.length) {
                String roleName = roles[i].getName();
                if (roleName != null) {
                    RoleEntry re = new RoleEntry(roleName);
                    this.roleMap.put(roleName, re);
                    Acl.Perm[] perms = roles[i].getPerm();
                    if (perms != null) {
                        int j = 0;
                        while (j < perms.length) {
                            String actions;
                            Acl.Perm perm = perms[j];
                            String className = perm.getClazz().intern();
                            String name = perm.getN();
                            if (name != null && name.length() == 0) {
                                name = null;
                            }
                            if ((actions = perm.getActions()) != null && actions.length() == 0) {
                                actions = null;
                            }
                            Permission permission = null;
                            try {
                                permission = Acl2JavaAcl.getPermission(className, name, actions);
                                re.addPermission(permission);
                            }
                            catch (Exception e) {
                                debug.error("Cannot instantiate permission class!", e);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static Permission getPermission(String className, String name, String actions) throws Exception {
        Permission permission = null;
        if (className == "org.systinet.security.perm.WSInvokePermission") {
            permission = name == null ? new WSInvokePermission() : (actions == null ? new WSInvokePermission(name) : new WSInvokePermission(name, actions));
        } else if (className == "org.systinet.security.perm.WASPRole") {
            if (name == null) {
                throw new Exception("WASPRole permission must contain name!");
            }
            permission = new WASPRole(name);
        } else {
            Class<?> c = Class.forName(className);
            if (name == null) {
                permission = (Permission)c.newInstance();
            } else if (actions == null) {
                Constructor<?> constr = c.getConstructor(STR_ARR1);
                permission = (Permission)constr.newInstance(name);
            } else {
                Constructor<?> constr = c.getConstructor(STR_ARR2);
                permission = (Permission)constr.newInstance(name, actions);
            }
        }
        return permission;
    }

    public void fillPermissions(Subject subject, PermissionCollection perms) {
        GrantEntry ge = (GrantEntry)this.princMap.get(NO_PRINC);
        if (ge != null) {
            Enumeration enumeration = ge.getPermissions();
            while (enumeration.hasMoreElements()) {
                RoleEntry re;
                Permission perm = (Permission)enumeration.nextElement();
                perms.add(perm);
                if (!(perm instanceof WASPRole) || (re = (RoleEntry)this.roleMap.get(perm.getName())) == null) continue;
                Enumeration enum2 = re.getPermissions();
                while (enum2.hasMoreElements()) {
                    perm = (Permission)enum2.nextElement();
                    perms.add(perm);
                }
            }
        }
        if (subject == null) {
            return;
        }
        Iterator<Principal> iter = subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            Principal princ = iter.next();
            ge = (GrantEntry)this.princMap.get(princ);
            if (ge == null) continue;
            Enumeration enumeration = ge.getPermissions();
            while (enumeration.hasMoreElements()) {
                RoleEntry re;
                Permission perm = (Permission)enumeration.nextElement();
                perms.add(perm);
                if (!(perm instanceof WASPRole) || (re = (RoleEntry)this.roleMap.get(perm.getName())) == null) continue;
                Enumeration enum2 = re.getPermissions();
                while (enum2.hasMoreElements()) {
                    perm = (Permission)enum2.nextElement();
                    perms.add(perm);
                }
            }
        }
    }

    public PrincipalEntries getPrincipalEntries() {
        return new PrincipalEntriesImpl();
    }

    public PrincipalEntries getPrincipalEntries(Permission perm) {
        return new PrincipalEntriesImpl(perm);
    }

    public PrincipalEntries getPrincipalEntries(PermissionCollection permCollection) {
        return new PrincipalEntriesImpl(permCollection);
    }

    public Iterator getRoleNames() {
        return ((AbstractList)new ArrayList(this.roleMap.keySet())).iterator();
    }

    public boolean addPermissionToRole(String roleName, Permission permission) {
        if (roleName == null) {
            return false;
        }
        RoleEntry re = (RoleEntry)this.roleMap.get(roleName);
        boolean ret = false;
        if (re == null) {
            re = new RoleEntry(roleName);
            this.roleMap.put(roleName, re);
            ret = true;
        }
        if (permission != null && !(permission instanceof WASPRole) && !re.containsPermission(permission)) {
            re.addPermission(permission);
            return true;
        }
        return ret;
    }

    public boolean removePermissionFromRole(String roleName, Permission permission) {
        if (roleName == null) {
            return false;
        }
        RoleEntry re = (RoleEntry)this.roleMap.get(roleName);
        if (re == null) {
            return false;
        }
        if (permission == null) {
            this.roleMap.remove(roleName);
            return false;
        }
        if (re.containsPermission(permission)) {
            re.removePermission(permission);
            return true;
        }
        return false;
    }

    public void fillRolePermissions(String roleName, PermissionCollection perms) {
        RoleEntry re = (RoleEntry)this.roleMap.get(roleName);
        if (re != null) {
            Enumeration enumeration = re.getPermissions();
            while (enumeration.hasMoreElements()) {
                Permission perm = (Permission)enumeration.nextElement();
                perms.add(perm);
            }
        }
    }

    public void fillPermissions(Principal principal, PermissionCollection perms, boolean roleInheritted) {
        if (roleInheritted) {
            this.fillPermissions(principal, perms);
        } else {
            Object key = principal != null ? principal : NO_PRINC;
            GrantEntry ge = (GrantEntry)this.princMap.get(key);
            if (ge != null) {
                Enumeration enumeration = ge.getPermissions();
                while (enumeration.hasMoreElements()) {
                    Permission perm = (Permission)enumeration.nextElement();
                    perms.add(perm);
                }
            }
        }
    }

    public void fillPermissions(Principal principal, PermissionCollection perms) {
        Object key = principal != null ? principal : NO_PRINC;
        GrantEntry ge = (GrantEntry)this.princMap.get(key);
        if (ge != null) {
            Enumeration enumeration = ge.getPermissions();
            while (enumeration.hasMoreElements()) {
                RoleEntry re;
                Permission perm = (Permission)enumeration.nextElement();
                perms.add(perm);
                if (!(perm instanceof WASPRole) || (re = (RoleEntry)this.roleMap.get(perm.getName())) == null) continue;
                Enumeration enum2 = re.getPermissions();
                while (enum2.hasMoreElements()) {
                    perm = (Permission)enum2.nextElement();
                    perms.add(perm);
                }
            }
        }
    }

    public void addPermissions(Principal principal, PermissionCollection collection) {
        GrantEntry ge = null;
        if (principal == null) {
            ge = (GrantEntry)this.princMap.get(NO_PRINC);
            if (ge == null) {
                ge = new GrantEntry();
                this.princMap.put(NO_PRINC, ge);
            }
        } else {
            ge = (GrantEntry)this.princMap.get(principal);
            if (ge == null) {
                ge = new GrantEntry(principal);
                this.princMap.put(principal, ge);
            }
        }
        Enumeration<Permission> enumeration = collection.elements();
        while (enumeration.hasMoreElements()) {
            RoleEntry re;
            Permission p = enumeration.nextElement();
            if (ge.containsPermission(p) || p instanceof WASPRole && (re = (RoleEntry)this.roleMap.get(p.getName())) == null) continue;
            ge.addPermission(p);
        }
    }

    public boolean addPermission(Principal principal, Permission permission) {
        GrantEntry ge = null;
        boolean isNew = false;
        if (permission instanceof WASPRole && this.roleMap.get(permission.getName()) == null) {
            return false;
        }
        if (principal == null) {
            ge = (GrantEntry)this.princMap.get(NO_PRINC);
            if (ge == null) {
                ge = new GrantEntry();
                isNew = true;
                this.princMap.put(NO_PRINC, ge);
            }
        } else {
            ge = (GrantEntry)this.princMap.get(principal);
            if (ge == null) {
                ge = new GrantEntry(principal);
                isNew = true;
                this.princMap.put(principal, ge);
            }
        }
        if (isNew) {
            ge.addPermission(permission);
        } else if (!ge.containsPermission(permission)) {
            ge.addPermission(permission);
            return true;
        }
        return false;
    }

    public boolean removePermission(Principal principal, Permission permission) {
        GrantEntry ge = null;
        ge = principal == null ? (GrantEntry)this.princMap.get(NO_PRINC) : (GrantEntry)this.princMap.get(principal);
        if (ge == null) {
            return false;
        }
        return ge.removePermission(permission);
    }

    public boolean removePrincipalEntry(Principal principal) {
        if (principal == null) {
            return this.princMap.remove(NO_PRINC) != null;
        }
        return this.princMap.remove(principal) != null;
    }

    public Acl.Grant[] getGrants() {
        Iterator iter = this.princMap.values().iterator();
        Acl.Grant[] toRet = new Acl.Grant[16];
        int cnt = 0;
        while (iter.hasNext()) {
            GrantEntry ge = (GrantEntry)iter.next();
            if (ge == null) continue;
            Principal princ = ge.getPrincipal();
            int permCnt = ge.getPermissionCount();
            if (permCnt == 0) continue;
            Acl.Grant grant = this.acl.newGrant();
            if (princ != null) {
                Acl.Princ aclpr = grant.newPrinc();
                aclpr.setClazz(princ.getClass().getName());
                aclpr.setN(princ.getName());
                grant.setPrinc(aclpr);
            }
            Acl.Perm[] perms = new Acl.Perm[permCnt];
            Enumeration enumeration = ge.getPermissions();
            int permIndex = 0;
            while (enumeration.hasMoreElements()) {
                Permission permission = (Permission)enumeration.nextElement();
                if (permission instanceof WASPRole && this.roleMap.get(permission.getName()) == null) continue;
                Acl.Perm p = grant.newPerm();
                String actionsToSet = permission.getActions();
                if (actionsToSet == null || actionsToSet.length() == 0) {
                    actionsToSet = null;
                }
                p.setActions(actionsToSet);
                p.setClazz(permission.getClass().getName());
                p.setN(permission.getName());
                perms[permIndex] = p;
                ++permIndex;
            }
            if (permIndex != permCnt) {
                Acl.Perm[] newPerms = new Acl.Perm[permIndex];
                System.arraycopy(perms, 0, newPerms, 0, permIndex);
                perms = newPerms;
            }
            grant.setPerm(perms);
            if (cnt == toRet.length) {
                Acl.Grant[] newRet = new Acl.Grant[toRet.length * 2];
                System.arraycopy(toRet, 0, newRet, 0, cnt);
                toRet = newRet;
            }
            toRet[cnt] = grant;
            ++cnt;
        }
        if (toRet.length != cnt) {
            Acl.Grant[] newRet = new Acl.Grant[cnt];
            System.arraycopy(toRet, 0, newRet, 0, cnt);
            toRet = newRet;
        }
        return toRet;
    }

    public Acl.Role[] getRoles() {
        Acl.Role[] roles = this.acl.getRole();
        int i = 0;
        while (i < roles.length) {
            Acl.Role role = roles[i];
            role.setName(null);
            ++i;
        }
        Iterator iter = this.roleMap.values().iterator();
        Acl.Role[] toRet = new Acl.Role[16];
        int cnt = 0;
        while (iter.hasNext()) {
            RoleEntry re = (RoleEntry)iter.next();
            if (re == null) continue;
            String roleName = re.getName();
            Acl.Role role = this.acl.newRole();
            role.setName(roleName);
            int rolePermCnt = re.getPermissionCount();
            if (rolePermCnt != 0) {
                Acl.Perm[] perms = new Acl.Perm[rolePermCnt];
                Enumeration enumeration = re.getPermissions();
                int permIndex = 0;
                while (enumeration.hasMoreElements()) {
                    Acl.Perm p = role.newPerm();
                    Permission permission = (Permission)enumeration.nextElement();
                    String actionsToSet = permission.getActions();
                    if (actionsToSet == null || actionsToSet.length() == 0) {
                        actionsToSet = null;
                    }
                    p.setActions(actionsToSet);
                    p.setClazz(permission.getClass().getName());
                    p.setN(permission.getName());
                    perms[permIndex] = p;
                    ++permIndex;
                }
                role.setPerm(perms);
            }
            if (cnt == toRet.length) {
                Acl.Role[] newRet = new Acl.Role[toRet.length * 2];
                System.arraycopy(toRet, 0, newRet, 0, cnt);
                toRet = newRet;
            }
            toRet[cnt] = role;
            ++cnt;
        }
        if (toRet.length != cnt) {
            Acl.Role[] newRet = new Acl.Role[cnt];
            System.arraycopy(toRet, 0, newRet, 0, cnt);
            toRet = newRet;
        }
        return toRet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PrincipalEntriesImpl
    implements PrincipalEntries {
        Permission filter;
        PermissionCollection collection;
        Principal[] principals;
        int elems;
        int curElem;

        PrincipalEntriesImpl() {
            this.principals = new Principal[16];
            this.elems = 0;
            this.curElem = 0;
            Iterator keys = Acl2JavaAcl.this.princMap.keySet().iterator();
            while (keys.hasNext()) {
                Object value = keys.next();
                if (value == NO_PRINC) {
                    this.putPrincipal(null);
                    continue;
                }
                this.putPrincipal((Principal)value);
            }
        }

        private void collectPrincPermission(Permission perm) {
            if (perm.getClass().equals(this.filter.getClass())) {
                if (this.collection == null) {
                    this.collection = this.filter.newPermissionCollection();
                    if (this.collection == null) {
                        this.collection = new Permissions();
                    }
                }
                this.collection.add(perm);
            }
        }

        private void resetCollection() {
            this.collection = null;
        }

        PrincipalEntriesImpl(Permission filter) {
            this.filter = filter;
            this.principals = new Principal[16];
            this.elems = 0;
            this.curElem = 0;
            Iterator keys = Acl2JavaAcl.this.princMap.keySet().iterator();
            while (keys.hasNext()) {
                Object value = keys.next();
                GrantEntry ge = (GrantEntry)Acl2JavaAcl.this.princMap.get(value);
                if (ge == null) continue;
                Enumeration enumeration = ge.getPermissions();
                boolean implied = false;
                block1: while (enumeration.hasMoreElements()) {
                    RoleEntry re;
                    Permission perm = (Permission)enumeration.nextElement();
                    if (perm.implies(filter)) {
                        implied = true;
                        break;
                    }
                    this.collectPrincPermission(perm);
                    if (!(perm instanceof WASPRole) || (re = (RoleEntry)Acl2JavaAcl.this.roleMap.get(perm.getName())) == null) continue;
                    Enumeration enum2 = re.getPermissions();
                    while (enum2.hasMoreElements()) {
                        perm = (Permission)enum2.nextElement();
                        if (perm.implies(filter)) {
                            implied = true;
                            break block1;
                        }
                        this.collectPrincPermission(perm);
                    }
                }
                if (!implied) {
                    if (this.collection != null && this.collection.implies(filter)) {
                        this.resetCollection();
                    } else {
                        this.resetCollection();
                        continue;
                    }
                }
                if (value == NO_PRINC) {
                    this.putPrincipal(null);
                    continue;
                }
                this.putPrincipal((Principal)value);
            }
        }

        PrincipalEntriesImpl(PermissionCollection filter) {
            this.principals = new Principal[16];
            this.elems = 0;
            this.curElem = 0;
            Iterator keys = Acl2JavaAcl.this.princMap.keySet().iterator();
            while (keys.hasNext()) {
                Object value = keys.next();
                Principal princ = value == NO_PRINC ? null : (Principal)value;
                Permissions perms = new Permissions();
                Acl2JavaAcl.this.fillPermissions(princ, perms, true);
                boolean implies = true;
                Enumeration<Permission> enumeration = filter.elements();
                while (enumeration.hasMoreElements()) {
                    if (perms.implies(enumeration.nextElement())) continue;
                    implies = false;
                    break;
                }
                if (!implies) continue;
                this.putPrincipal(princ);
            }
        }

        private void putPrincipal(Principal princ) {
            if (this.elems == this.principals.length) {
                Principal[] newPrincs = new Principal[this.elems * 2];
                System.arraycopy(this.principals, 0, newPrincs, 0, this.elems);
                this.principals = newPrincs;
            }
            this.principals[this.elems] = princ;
            ++this.elems;
        }

        public boolean hasNext() {
            return this.curElem != this.elems;
        }

        public Object next() {
            return this.getPrincipal();
        }

        public void remove() {
            throw new UnsupportedOperationException("You cannot remove from this principal entries!");
        }

        public Principal getPrincipal() {
            if (this.curElem == this.elems) {
                throw new NoSuchElementException("No more elements available in principal entries");
            }
            Principal princ = this.principals[this.curElem];
            ++this.curElem;
            return princ;
        }
    }

    public class RoleEntry {
        private Vector perms;
        private String name;

        RoleEntry() {
            this.name = null;
            this.perms = new Vector();
        }

        RoleEntry(String name) {
            this.name = name;
            this.perms = new Vector();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String getName() {
            return this.name;
        }

        public Enumeration getPermissions() {
            return this.perms.elements();
        }

        public int getPermissionCount() {
            return this.perms.size();
        }

        public void addPermission(Permission perm) {
            if (!(perm instanceof WASPRole)) {
                this.perms.add(perm);
            }
        }

        public boolean containsPermission(Permission perm) {
            return this.perms.contains(perm);
        }

        public boolean removePermission(Permission perm) {
            boolean retVal = this.perms.remove(perm);
            Object[] arr = this.perms.toArray();
            int i = 0;
            while (i < arr.length) {
                Permission next = (Permission)arr[i];
                if (next.getClass().getName().equals(perm.getClass().getName()) && perm.implies(next)) {
                    retVal |= this.perms.remove(next);
                }
                ++i;
            }
            return retVal;
        }
    }

    public class GrantEntry {
        private Vector perms;
        private Principal princ;

        GrantEntry() {
            this.princ = null;
            this.perms = new Vector();
        }

        GrantEntry(Principal princ) {
            this.princ = princ;
            this.perms = new Vector();
        }

        public int hashCode() {
            if (this.princ == null) {
                return NO_PRINC.hashCode();
            }
            return this.princ.hashCode();
        }

        public Principal getPrincipal() {
            return this.princ;
        }

        public Enumeration getPermissions() {
            return this.perms.elements();
        }

        public int getPermissionCount() {
            return this.perms.size();
        }

        public void addPermission(Permission perm) {
            this.perms.add(perm);
        }

        public boolean containsPermission(Permission perm) {
            return this.perms.contains(perm);
        }

        public boolean removePermission(Permission perm) {
            boolean retVal = this.perms.remove(perm);
            Object[] arr = this.perms.toArray();
            int i = 0;
            while (i < arr.length) {
                Permission next = (Permission)arr[i];
                if (next.getClass().getName().equals(perm.getClass().getName()) && perm.implies(next)) {
                    retVal |= this.perms.remove(next);
                }
                ++i;
            }
            return retVal;
        }
    }
}

