/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.debug.Category;
import com.idoox.security.util.CertUtilBase;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.KeyStoreException;
import org.idoox.security.pstore.PStore;

public class CertUtil {
    private static Category dbg = Category.getCategory((class$com$idoox$security$util$CertUtil == null ? (class$com$idoox$security$util$CertUtil = CertUtil.class$("com.idoox.security.util.CertUtil")) : class$com$idoox$security$util$CertUtil).getName());
    static /* synthetic */ Class class$com$idoox$security$util$CertUtil;

    public static void StoreCertificateChain(Certificate[] certs) {
        PStore pstore;
        try {
            pstore = PStore.getInstance(null);
        }
        catch (BadPasswordException e) {
            return;
        }
        KeyStore kstore = pstore.getKeyStore();
        String alias = ((X509Certificate)certs[0]).getSubjectDN().toString();
        if (kstore.containsAlias(alias)) {
            return;
        }
        try {
            kstore.setCertificateEntry(alias, certs);
        }
        catch (BadPasswordException e) {
        }
        catch (KeyStoreException e) {
            // empty catch block
        }
    }

    public static void StoreX509Certificate(X509Certificate cert) {
        PStore pstore;
        try {
            pstore = PStore.getInstance(null);
        }
        catch (BadPasswordException e) {
            return;
        }
        KeyStore kstore = pstore.getKeyStore();
        String alias = cert.getSubjectDN().toString();
        if (kstore.containsAlias(alias)) {
            return;
        }
        Certificate[] chain = new Certificate[]{cert};
        try {
            kstore.setCertificateEntry(alias, chain);
        }
        catch (BadPasswordException e) {
        }
        catch (KeyStoreException e) {
            // empty catch block
        }
    }

    public static boolean IsCertChainTrusted(Certificate[] certs) {
        PStore pstore;
        try {
            pstore = PStore.getInstance(null);
        }
        catch (BadPasswordException e) {
            return false;
        }
        KeyStore kstore = pstore.getKeyStore();
        return CertUtilBase.isCertChainTrusted((Certificate[])certs, (KeyStore)kstore);
    }

    public static boolean IsCertTrusted(X509Certificate cert) {
        PStore pstore;
        try {
            pstore = PStore.getInstance(null);
        }
        catch (BadPasswordException e) {
            return false;
        }
        KeyStore kstore = pstore.getKeyStore();
        return CertUtilBase.isCertTrusted((X509Certificate)cert, (KeyStore)kstore);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

