/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.WrapBody;
import com.idoox.security.spkm.WrapHeader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SpkmWrap
extends Sequence {
    private WrapHeader wrapHeader;
    private WrapBody wrapBody;

    public SpkmWrap(WrapHeader wrapHeader, WrapBody wrapBody) {
        this.wrapHeader = wrapHeader;
        this.addComponent((Asn1)this.wrapHeader);
        this.wrapBody = wrapBody;
        this.addComponent((Asn1)this.wrapBody);
    }

    public SpkmWrap(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SpkmWrap(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.wrapHeader = new WrapHeader(((Asn1)((Constructed)this).components.get(0)).encode());
        this.wrapBody = new WrapBody(((Asn1)((Constructed)this).components.get(1)).encode());
    }

    public WrapHeader getWrapHeader() {
        return this.wrapHeader;
    }

    public WrapBody getWrapBody() {
        return this.wrapBody;
    }
}

