/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.debug.Category;
import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Integer;
import com.idoox.security.spkm.GSSManagerImpl;
import com.idoox.security.spkm.SpkmParseTokenResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class SpkmSupport {
    public static final int GSS_INIT_TOKEN = 1;
    public static final int GSS_ACCEPT_TOKEN = 2;
    public static final int GSS_ERROR_TOKEN = 3;
    public static final int GSS_GETMIC_TOKEN = 4;
    public static final int GSS_WRAP_TOKEN = 5;
    public static final int GSS_DELETE_TOKEN = 6;
    public static String[] tokenTypes = new String[]{"Invalid", "GSS_INIT_TOKEN", "GSS_ACCEPT_TOKEN", "GSS_ERROR_TOKEN", "GSS_GETMIC_TOKEN", "GSS_WRAP_TOKEN", "GSS_DELETE_TOKEN"};
    private static Category dbg = Category.getCategory("com.idoox.security.spkm.SpkmSupport");

    public static void spkmParseToken(byte[] token, SpkmParseTokenResult retval) throws GSSException {
        ByteArrayInputStream bin = new ByteArrayInputStream(token);
        SpkmSupport.spkmParseToken(bin, retval);
    }

    public static void spkmParseToken(InputStream token, SpkmParseTokenResult retval) throws GSSException {
        try {
            byte[] contextId;
            int tag = Asn1Util.decodeTag(token);
            if (tag != 0) {
                throw new GSSException(13, 0, "Invalid starting tag - must be 'APPLICATION 0'");
            }
            Asn1Util.decodeLengthOctets(token);
            retval.mechType = new Oid(token);
            tag = Asn1Util.decodeTag(token);
            switch (tag) {
                case 0: 
                case 2: {
                    retval.tokenType = 1;
                    break;
                }
                case 1: {
                    retval.tokenType = 2;
                    break;
                }
                case 3: {
                    retval.tokenType = 3;
                    break;
                }
                case 4: {
                    retval.tokenType = 4;
                    break;
                }
                case 5: {
                    retval.tokenType = 5;
                    break;
                }
                case 6: {
                    retval.tokenType = 6;
                    break;
                }
                default: {
                    throw new GSSException(9);
                }
            }
            if (retval.tokenType != 4 && retval.tokenType != 5 && retval.tokenType != 6) {
                return;
            }
            Asn1Util.decodeLengthOctets(token);
            Asn1Util.decodeTag(token);
            Asn1Util.decodeLengthOctets(token);
            try {
                Integer tokId = (Integer)Asn1.decode((InputStream)token);
            }
            catch (ClassCastException e) {
                throw new GSSException(9, 0, "Invalid or missing token id");
            }
            try {
                contextId = ((BitString)Asn1.decode((InputStream)token)).getBytes();
            }
            catch (ClassCastException e) {
                throw new GSSException(9, 0, "Invalid or missing context id");
            }
            retval.context = GSSManagerImpl.getContext(contextId);
            if (retval.context == null) {
                throw new GSSException(8);
            }
        }
        catch (Asn1Exception e) {
            throw new GSSException(13, 0, e.getMessage());
        }
    }

    private static abstract class Asn1Util
    extends Asn1 {
        private Asn1Util() {
        }

        static int decodeLengthOctets(InputStream in) throws Asn1Exception {
            int[] length = new int[]{0};
            return Asn1.decodeLengthOctets((InputStream)in, (int[])length);
        }

        static int decodeTag(InputStream in) throws Asn1Exception {
            try {
                int tagNum;
                byte tag = (byte)in.read();
                byte classType = (byte)(tag & 0xFFFFFFC0);
                if ((tag & 0x1F) == 31) {
                    int[] intlen = new int[]{0};
                    tagNum = Asn1.decodeHighTag((InputStream)in, (int[])intlen);
                } else {
                    tagNum = tag & 0x1F;
                }
                return tagNum;
            }
            catch (IOException e) {
                throw new Asn1Exception(e.getMessage());
            }
        }
    }
}

