/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.CertificationData;
import com.idoox.security.spkm.RepTIToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SpkmRepTI
extends Sequence {
    private RepTIToken responseToken;
    private CertificationData certifData;

    public SpkmRepTI(RepTIToken responseToken, CertificationData certifData) {
        this.responseToken = responseToken;
        this.addComponent((Asn1)this.responseToken);
        this.certifData = certifData;
        if (certifData != null) {
            this.addComponent((Asn1)this.certifData);
        }
    }

    public SpkmRepTI(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SpkmRepTI(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.responseToken = new RepTIToken(((Asn1)((Constructed)this).components.get(0)).encode());
        if (((Constructed)this).components.size() > 1) {
            this.certifData = new CertificationData(((Asn1)((Constructed)this).components.get(1)).encode());
        }
    }

    public RepTIToken getResponseToken() {
        return this.responseToken;
    }

    public CertificationData getCertifData() {
        return this.certifData;
    }
}

