/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.RepITToken;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AlgorithmParameters;

public class SpkmRepIT
extends Sequence {
    private RepITToken responseToken;
    private AlgorithmId algId;
    private byte[] repITInteg;

    public SpkmRepIT(RepITToken responseToken, String algName, AlgorithmParameters algParams, byte[] repITInteg) {
        this.responseToken = responseToken;
        this.addComponent((Asn1)this.responseToken);
        try {
            this.algId = new AlgorithmId(OID.getAlgOid((String)algName), algParams);
        }
        catch (Asn1Exception e) {
            try {
                this.algId = new AlgorithmId(OID.getAlgOid((String)algName));
            }
            catch (Asn1Exception e1) {
                this.algId = null;
            }
        }
        this.addComponent((Asn1)this.algId);
        this.repITInteg = repITInteg;
        this.addComponent((Asn1)new BitString(this.repITInteg));
    }

    public SpkmRepIT(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SpkmRepIT(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.responseToken = new RepITToken(((Asn1)((Constructed)this).components.get(0)).encode());
        this.algId = new AlgorithmId(((Asn1)((Constructed)this).components.get(1)).encode());
        this.repITInteg = ((BitString)((Constructed)this).components.get(2)).getBytes();
    }

    public RepITToken getResponseToken() {
        return this.responseToken;
    }

    public AlgorithmId getAlgId() {
        return this.algId;
    }

    public String getAlgName() {
        return OID.getAlgName((String)this.algId.getOid());
    }

    public AlgorithmParameters getAlgParams() {
        return this.algId.getParams();
    }

    public byte[] getRepITInteg() {
        return this.repITInteg;
    }
}

