/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.MicHeader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SpkmMic
extends Sequence {
    private MicHeader micHeader;
    private byte[] intCksum;

    public SpkmMic(MicHeader micHeader, byte[] intCksum) {
        this.micHeader = micHeader;
        this.addComponent((Asn1)this.micHeader);
        this.intCksum = intCksum;
        this.addComponent((Asn1)new BitString(this.intCksum));
    }

    public SpkmMic(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SpkmMic(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.micHeader = new MicHeader(((Asn1)((Constructed)this).components.get(0)).encode());
        this.intCksum = ((BitString)((Constructed)this).components.get(1)).getBytes();
    }

    public MicHeader getMicHeader() {
        return this.micHeader;
    }

    public byte[] getIntCksum() {
        return this.intCksum;
    }
}

