/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.x509.X500Name;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RepITToken
extends Sequence {
    private int tokId = 768;
    private byte[] contextId;
    private byte[] randSrc;
    private byte[] randTarg;
    private X500Name targName;
    private X500Name srcName;
    private byte[] keyEstbRep;

    public RepITToken(byte[] contextId, byte[] randSrc, byte[] randTarg, X500Name targName, X500Name srcName, byte[] keyEstbRep) {
        this.addComponent((Asn1)new Integer(this.tokId));
        this.contextId = contextId;
        this.addComponent((Asn1)new BitString(this.contextId));
        this.randSrc = randSrc;
        this.addComponent((Asn1)new BitString(this.randSrc));
        this.randTarg = randTarg;
        this.addComponent((Asn1)new BitString(this.randTarg));
        this.targName = targName;
        this.addComponent((Asn1)this.targName);
        this.srcName = srcName;
        if (srcName != null) {
            this.addComponent((Asn1)this.srcName);
        }
        this.keyEstbRep = keyEstbRep;
        if (keyEstbRep != null) {
            this.addComponent((Asn1)new BitString(this.keyEstbRep));
        }
    }

    public RepITToken(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public RepITToken(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        int i = 0;
        this.doDecode(encoded);
        this.tokId = ((Integer)((Constructed)this).components.get(i++)).getInt();
        if (this.tokId != 768) {
            throw new Asn1Exception("Invalid token id");
        }
        this.contextId = ((BitString)((Constructed)this).components.get(i++)).getBytes();
        this.randSrc = ((BitString)((Constructed)this).components.get(i++)).getBytes();
        this.randTarg = ((BitString)((Constructed)this).components.get(i++)).getBytes();
        this.targName = new X500Name(((Asn1)((Constructed)this).components.get(i++)).encode());
        if (i == ((Constructed)this).components.size()) {
            return;
        }
        try {
            Sequence seq = (Sequence)((Constructed)this).components.get(i);
            this.srcName = new X500Name(seq.encode());
            if (++i == ((Constructed)this).components.size()) {
                return;
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            this.keyEstbRep = ((BitString)((Constructed)this).components.get(i)).getBytes();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public byte[] getContextId() {
        return this.contextId;
    }

    public byte[] getRandSrc() {
        return this.randSrc;
    }

    public byte[] getRandTarg() {
        return this.randTarg;
    }

    public X500Name getTargName() {
        return this.targName;
    }

    public X500Name getSrcName() {
        return this.srcName;
    }

    public byte[] getKeyEstbRep() {
        return this.keyEstbRep;
    }
}

