/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Explicit;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Oid;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.SpkmDel;
import com.idoox.security.spkm.SpkmError;
import com.idoox.security.spkm.SpkmMic;
import com.idoox.security.spkm.SpkmRepIT;
import com.idoox.security.spkm.SpkmRepTI;
import com.idoox.security.spkm.SpkmReq;
import com.idoox.security.spkm.SpkmWrap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class InitialContextToken
extends Explicit {
    public static final int TYPE_SPKM_REQ = 0;
    public static final int TYPE_SPKM_REP_TI = 1;
    public static final int TYPE_SPKM_REP_IT = 2;
    public static final int TYPE_SPKM_ERROR = 3;
    public static final int TYPE_SPKM_MIC = 4;
    public static final int TYPE_SPKM_WRAP = 5;
    public static final int TYPE_SPKM_DEL = 6;
    private Sequence innerContextToken;
    private Oid thisMech;

    public InitialContextToken() {
        ((Asn1)this).tagNum = 0;
        ((Asn1)this).classType = (byte)64;
        try {
            this.thisMech = new Oid("1.3.6.1.5.5.1.1");
        }
        catch (Asn1Exception asn1Exception) {
            // empty catch block
        }
        this.addComponent((Asn1)this.thisMech);
    }

    public InitialContextToken(SpkmReq req) {
        this();
        Implicit imp = new Implicit(-128, 0);
        imp.addComponent((Asn1)req);
        this.addComponent((Asn1)imp);
    }

    public InitialContextToken(SpkmRepTI repTI) {
        this();
        Implicit imp = new Implicit(-128, 1);
        imp.addComponent((Asn1)repTI);
        this.addComponent((Asn1)imp);
    }

    public InitialContextToken(SpkmRepIT repIT) {
        this();
        Implicit imp = new Implicit(-128, 2);
        imp.addComponent((Asn1)repIT);
        this.addComponent((Asn1)imp);
    }

    public InitialContextToken(SpkmError error) {
        this();
        Implicit imp = new Implicit(-128, 3);
        imp.addComponent((Asn1)error);
        this.addComponent((Asn1)imp);
    }

    public InitialContextToken(SpkmMic mic) {
        this();
        Implicit imp = new Implicit(-128, 4);
        imp.addComponent((Asn1)mic);
        this.addComponent((Asn1)imp);
    }

    public InitialContextToken(SpkmWrap wrap) {
        this();
        Implicit imp = new Implicit(-128, 5);
        imp.addComponent((Asn1)wrap);
        this.addComponent((Asn1)imp);
    }

    public InitialContextToken(SpkmDel del) {
        this();
        Implicit imp = new Implicit(-128, 6);
        imp.addComponent((Asn1)del);
        this.addComponent((Asn1)imp);
    }

    public InitialContextToken(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public InitialContextToken(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        if (((Asn1)this).classType != 64) {
            throw new Asn1Exception("Invalid class type");
        }
        if (((Asn1)this).tagNum != 0) {
            throw new Asn1Exception("Invalid tag number");
        }
        this.thisMech = (Oid)((Constructed)this).components.get(0);
        Asn1 seq = (Asn1)((Constructed)this).components.get(1);
        switch (seq.getTagNumber()) {
            case 0: {
                this.innerContextToken = new SpkmReq(seq.encode());
                break;
            }
            case 1: {
                this.innerContextToken = new SpkmRepTI(seq.encode());
                break;
            }
            case 2: {
                this.innerContextToken = new SpkmRepIT(seq.encode());
                break;
            }
            case 3: {
                this.innerContextToken = new SpkmError(seq.encode());
                break;
            }
            case 4: {
                this.innerContextToken = new SpkmMic(seq.encode());
                break;
            }
            case 5: {
                this.innerContextToken = new SpkmWrap(seq.encode());
                break;
            }
            case 6: {
                this.innerContextToken = new SpkmDel(seq.encode());
                break;
            }
            default: {
                throw new Asn1Exception("Invalid tag number");
            }
        }
    }

    public Oid getThisMech() {
        return this.thisMech;
    }

    public int getInnerContentsType() {
        return ((Asn1)((Constructed)this).components.get(1)).getTagNumber();
    }

    public SpkmReq getReq() {
        return (SpkmReq)this.innerContextToken;
    }

    public SpkmRepTI getRepTI() {
        return (SpkmRepTI)this.innerContextToken;
    }

    public SpkmRepIT getRepIT() {
        return (SpkmRepIT)this.innerContextToken;
    }

    public SpkmError getError() {
        return (SpkmError)this.innerContextToken;
    }

    public SpkmMic getMic() {
        return (SpkmMic)this.innerContextToken;
    }

    public SpkmWrap getWrap() {
        return (SpkmWrap)this.innerContextToken;
    }

    public SpkmDel getDel() {
        return (SpkmDel)this.innerContextToken;
    }
}

