/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.debug.Category;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.spkm.GSSManagerImpl;
import com.idoox.security.x509.RDN;
import com.idoox.security.x509.X500Name;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GSSNameImpl
implements GSSName {
    Category dbg = Category.getCategory((class$com$idoox$security$spkm$GSSNameImpl == null ? (class$com$idoox$security$spkm$GSSNameImpl = GSSNameImpl.class$("com.idoox.security.spkm.GSSNameImpl")) : class$com$idoox$security$spkm$GSSNameImpl).getName());
    private boolean isMN;
    private X500Name name;
    private X509Certificate cert;
    private String nameStr;
    static /* synthetic */ Class class$com$idoox$security$spkm$GSSNameImpl;

    public GSSNameImpl(String nameStr, Oid oid) throws GSSException {
        if (nameStr.indexOf("CN=") != -1) {
            try {
                this.name = new X500Name(nameStr);
                this.nameStr = this.name.getName();
                return;
            }
            catch (Asn1Exception e) {
                // empty catch block
            }
        }
        if (oid.equals(GSSName.NT_USER_NAME)) {
            String dn = "CN=" + nameStr;
            try {
                this.name = new X500Name(dn);
            }
            catch (Asn1Exception e) {
                // empty catch block
            }
            this.nameStr = nameStr;
        } else if (oid.equals(GSSName.NT_HOSTBASED_SERVICE)) {
            String dn = "CN=" + nameStr;
            try {
                this.name = new X500Name(dn);
            }
            catch (Asn1Exception e) {
                // empty catch block
            }
            this.nameStr = nameStr;
        } else if (oid.equals(GSSName.NT_ANONYMOUS)) {
            try {
                this.name = new X500Name("CN=Anonymous");
            }
            catch (Asn1Exception asn1Exception) {
                // empty catch block
            }
            this.nameStr = "Anonymous";
        } else {
            throw new GSSException(3);
        }
        this.isMN = false;
    }

    public GSSNameImpl(byte[] name, Oid oid) throws GSSException {
        if (oid.equals(GSSName.NT_EXPORT_NAME)) {
            try {
                this.name = new X500Name(name);
                ArrayList rdns = this.name.getRDNs();
                RDN rdn = (RDN)rdns.get(0);
                String strRDN = rdn.getName();
                if (strRDN.startsWith("CN=")) {
                    this.nameStr = strRDN.substring(3);
                }
                this.nameStr = this.name.getName();
            }
            catch (Asn1Exception e) {
                throw new GSSException(2, 2, e.getMessage());
            }
        } else {
            throw new GSSException(3);
        }
    }

    public GSSNameImpl(X500Name name, X509Certificate cert) {
        this.isMN = true;
        this.name = name;
        this.cert = cert;
        ArrayList rdns = this.name.getRDNs();
        RDN rdn = (RDN)rdns.get(0);
        String strRDN = rdn.getName();
        this.nameStr = strRDN.startsWith("CN=") ? strRDN.substring(3) : this.name.getName();
    }

    public GSSNameImpl(X500Name name) {
        this.name = name;
        this.isMN = false;
        ArrayList rdns = this.name.getRDNs();
        RDN rdn = (RDN)rdns.get(0);
        String strRDN = rdn.getName();
        this.nameStr = strRDN.startsWith("CN=") ? strRDN.substring(3) : this.name.getName();
    }

    public boolean equals(GSSName another) throws GSSException {
        if (another instanceof GSSNameImpl) {
            GSSNameImpl other = (GSSNameImpl)another;
            if (this.isMN) {
                if (other.isMN) {
                    return this.name.equals((Object)other.name) && this.cert.equals(other.cert);
                }
                return false;
            }
            return this.name.equals((Object)other.name);
        }
        return false;
    }

    public boolean equals(Object another) {
        if (another instanceof GSSNameImpl) {
            try {
                return this.equals((GSSName)another);
            }
            catch (GSSException e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.isMN) {
            return this.name.hashCode() + this.cert.hashCode() + 1;
        }
        return this.name.hashCode();
    }

    public GSSName canonicalize(Oid mech) throws GSSException {
        if (mech != null && !GSSManagerImpl.Spkm_1.equals(mech)) {
            throw new GSSException(1);
        }
        return this;
    }

    public byte[] export() throws GSSException {
        return this.name.encode();
    }

    public String toString() {
        return this.nameStr;
    }

    public Oid getStringNameType() throws GSSException {
        return null;
    }

    public boolean isAnonymous() {
        try {
            X500Name anon_name = new X500Name("CN=Anonymous");
            return anon_name.equals((Object)this.name);
        }
        catch (Asn1Exception e) {
            return false;
        }
    }

    public boolean isMN() {
        return this.isMN;
    }

    public X500Name getX500Name() {
        return this.name;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public String getName() {
        return this.nameStr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

