/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.spkm.GSSContextImpl;
import com.idoox.security.spkm.GSSCredentialImpl;
import com.idoox.security.spkm.GSSNameImpl;
import java.security.Provider;
import java.util.HashMap;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GSSManagerImpl
extends GSSManager {
    static final Oid Spkm_1 = GSSManagerImpl.getOidInstance("1.3.6.1.5.5.1.1");
    static final Oid[] mechs = new Oid[]{Spkm_1};
    private static HashMap id2Context = new HashMap(11, 0.75f);
    private static GSSException GSS_OPERATION_UNAVAILABLE = new GSSException(16);

    private static Oid getOidInstance(String strVal) {
        Oid retVal = null;
        try {
            retVal = new Oid(strVal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public Oid[] getMechs() {
        return mechs;
    }

    public Oid[] getNamesForMech(Oid mech) throws GSSException {
        return null;
    }

    public Oid[] getMechsForName(Oid nameType) {
        return null;
    }

    public GSSName createName(String nameStr, Oid nameType) throws GSSException {
        return new GSSNameImpl(nameStr, nameType);
    }

    public GSSName createName(byte[] name, Oid nameType) throws GSSException {
        return new GSSNameImpl(name, nameType);
    }

    public GSSName createName(String nameStr, Oid nameType, Oid mech) throws GSSException {
        return new GSSNameImpl(nameStr, nameType);
    }

    public GSSName createName(byte[] name, Oid nameType, Oid mech) throws GSSException {
        return new GSSNameImpl(name, nameType);
    }

    public GSSCredential createCredential(int usage) throws GSSException {
        GSSName name = this.createName(System.getProperty("user.name"), GSSName.NT_USER_NAME);
        return new GSSCredentialImpl((GSSNameImpl)name, 0, usage);
    }

    public GSSCredential createCredential(GSSName aName, int lifetime, Oid mech, int usage) throws GSSException {
        return new GSSCredentialImpl((GSSNameImpl)aName, lifetime, usage);
    }

    public GSSCredential createCredential(GSSName aName, int lifetime, Oid[] mechs, int usage) throws GSSException {
        return new GSSCredentialImpl((GSSNameImpl)aName, lifetime, usage);
    }

    public GSSContext createContext(GSSName peer, Oid mech, GSSCredential myCred, int lifetime) throws GSSException {
        return new GSSContextImpl((GSSNameImpl)peer, (GSSCredentialImpl)myCred, lifetime);
    }

    public GSSContext createContext(GSSCredential myCred) throws GSSException {
        return new GSSContextImpl((GSSCredentialImpl)myCred);
    }

    public GSSContext createContext(byte[] interProcessToken) throws GSSException {
        return null;
    }

    public void addProviderAtFront(Provider p, Oid mech) throws GSSException {
        throw GSS_OPERATION_UNAVAILABLE;
    }

    public void addProviderAtEnd(Provider p, Oid mech) throws GSSException {
        throw GSS_OPERATION_UNAVAILABLE;
    }

    static void addContext(byte[] contextId, GSSContextImpl context) {
        ContextKey key = new ContextKey(contextId);
        id2Context.put(key, context);
    }

    static GSSContextImpl getContext(byte[] contextId) {
        ContextKey key = new ContextKey(contextId);
        return (GSSContextImpl)id2Context.get(key);
    }

    static GSSContextImpl removeContext(byte[] contextId) {
        ContextKey key = new ContextKey(contextId);
        return (GSSContextImpl)id2Context.remove(key);
    }

    private static class ContextKey {
        private byte[] id;
        private int hashCode;

        ContextKey(byte[] id) {
            this.id = id;
            if (this.id != null) {
                int i = 0;
                while (i < this.id.length) {
                    this.hashCode ^= this.id[i];
                    ++i;
                }
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other instanceof ContextKey) {
                ContextKey another = (ContextKey)other;
                if (another.hashCode == this.hashCode && another.id.length == this.id.length) {
                    int i = 0;
                    while (i < this.id.length) {
                        if (another.id[i] != this.id[i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

