/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.debug.Category;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.pstore.UserStoreHelper;
import com.idoox.security.rsa.RSACipher;
import com.idoox.security.spkm.Algs;
import com.idoox.security.spkm.CertificationData;
import com.idoox.security.spkm.CertificationPath;
import com.idoox.security.spkm.ContextData;
import com.idoox.security.spkm.GSSCredentialImpl;
import com.idoox.security.spkm.GSSManagerImpl;
import com.idoox.security.spkm.GSSNameImpl;
import com.idoox.security.spkm.InitialContextToken;
import com.idoox.security.spkm.MicHeader;
import com.idoox.security.spkm.Options;
import com.idoox.security.spkm.RepITToken;
import com.idoox.security.spkm.RepTIContents;
import com.idoox.security.spkm.RepTIToken;
import com.idoox.security.spkm.ReqContents;
import com.idoox.security.spkm.ReqToken;
import com.idoox.security.spkm.SeqNum;
import com.idoox.security.spkm.SpkmMic;
import com.idoox.security.spkm.SpkmRepIT;
import com.idoox.security.spkm.SpkmRepTI;
import com.idoox.security.spkm.SpkmReq;
import com.idoox.security.spkm.SpkmWrap;
import com.idoox.security.spkm.WrapBody;
import com.idoox.security.spkm.WrapHeader;
import com.idoox.security.util.Algorithms;
import com.idoox.security.util.CertUtil;
import com.idoox.security.util.OID;
import com.idoox.security.util.Random;
import com.idoox.security.x509.AlgorithmId;
import com.idoox.security.x509.X500Name;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.KeyStoreException;
import org.idoox.security.pstore.PStore;
import org.idoox.security.pstore.UserStore;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GSSContextImpl
implements GSSContext {
    private static Category dbg = Category.getCategory((class$com$idoox$security$spkm$GSSContextImpl == null ? (class$com$idoox$security$spkm$GSSContextImpl = GSSContextImpl.class$("com.idoox.security.spkm.GSSContextImpl")) : class$com$idoox$security$spkm$GSSContextImpl).getName());
    public static final int CTX_STATE_INVALID = 0;
    public static final int CTX_STATE_ESTABLISHING = 1;
    public static final int CTX_STATE_READY = 2;
    private int state = 0;
    private boolean isInitiator;
    private GSSCredentialImpl cred;
    private boolean isAnonymous;
    private byte[] contextId;
    private byte[] randomSrc;
    private byte[] randomTarg;
    private SecretKey sessionKey;
    private PublicKey targSigKey;
    private PublicKey targKEKey;
    private GSSNameImpl targetName;
    private Options ctxFlags;
    private long seqIn;
    private long seqOut;
    private Date notAfter;
    private AlgorithmId[] intgAlgs;
    private AlgorithmId[] owfAlgs;
    private AlgorithmId[] confAlgs;
    static /* synthetic */ Class class$com$idoox$security$spkm$GSSContextImpl;

    public GSSContextImpl(GSSNameImpl target, GSSCredentialImpl myCred, int lifetime) throws GSSException {
        this.isInitiator = true;
        this.targetName = target;
        if (myCred.getUsage() == 2) {
            throw new GSSException(10);
        }
        this.cred = myCred;
        this.randomSrc = new byte[8];
        this.contextId = new byte[10];
        this.ctxFlags = new Options();
        this.ctxFlags.setMutualState(true);
        try {
            KeyStore keyStore = PStore.getInstance(null).getKeyStore();
            String name = "USER_" + target.getName();
            String sigName = "USER_SIG_" + target.getName();
            if (!keyStore.containsAlias(name)) {
                this.ctxFlags.setTargetCertifDataRequired(true);
            } else {
                Certificate[] certs = keyStore.getCertificateChain(name);
                this.targKEKey = this.targSigKey = certs[0].getPublicKey();
                if (keyStore.containsAlias(sigName)) {
                    this.targSigKey = keyStore.getCertificateChain(sigName)[0].getPublicKey();
                }
            }
        }
        catch (BadPasswordException e) {
        }
        catch (KeyStoreException e) {
            // empty catch block
        }
    }

    public GSSContextImpl(GSSCredentialImpl myCred) throws GSSException {
        this.isInitiator = false;
        if (myCred.getUsage() == 1) {
            throw new GSSException(10);
        }
        this.cred = myCred;
        this.randomSrc = new byte[20];
    }

    public byte[] initSecContext(byte[] inputBuf, int offset, int len) throws GSSException {
        ByteArrayInputStream bin = null;
        if (inputBuf != null && inputBuf.length != 0) {
            if (len == 0) {
                len = inputBuf.length;
            }
            bin = new ByteArrayInputStream(inputBuf, offset, len);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.initSecContext(bin, bout);
        byte[] retval = bout.toByteArray();
        return retval.length == 0 ? null : retval;
    }

    public int initSecContext(InputStream inStream, OutputStream outStream) throws GSSException {
        if (!this.isInitiator) {
            throw new GSSException(16);
        }
        if (this.state == 2) {
            return 0;
        }
        if (this.state == 0) {
            ReqToken reqToken;
            ContextData ctxData;
            CertificationPath certPath = new CertificationPath(null, this.cred.getCertificate(), null, this.cred.getVerifCertificate(), null);
            CertificationData certData = new CertificationData(certPath, null);
            Algs confAlgs = null;
            if (this.ctxFlags.getConfState()) {
                confAlgs = new Algs(Algorithms.getConfAlgs());
            }
            Algs intgAlgs = new Algs(Algorithms.getIntgAlgs());
            Algs owfAlgs = new Algs(Algorithms.getOWFAlgs());
            Algs keyAlgs = null;
            try {
                keyAlgs = new Algs(new AlgorithmId[]{new AlgorithmId(OID.getAlgOid((String)"RSA"))});
            }
            catch (Asn1Exception e) {
                // empty catch block
            }
            if (this.ctxFlags.getSequenceState()) {
                this.seqOut = Random.getRandom().nextLong();
                ctxData = new ContextData(null, this.seqOut++, this.ctxFlags, confAlgs, intgAlgs, owfAlgs);
            } else {
                this.seqOut = 0L;
                ctxData = new ContextData(null, null, this.ctxFlags, confAlgs, intgAlgs, owfAlgs);
            }
            Random.getRandom().nextBytes(this.randomSrc);
            Random.getRandom().nextBytes(this.contextId);
            byte[] encryptedKey = null;
            if (this.targKEKey != null) {
                try {
                    RSACipher cipher = RSACipher.getInstance();
                    cipher.init(1, (Key)this.targKEKey, Random.getRandom());
                    String algName = OID.getAlgName((String)confAlgs.getAlgs()[0].getOid());
                    KeyGenerator kg = KeyGenerator.getInstance(algName);
                    kg.init(Random.getRandom());
                    this.sessionKey = kg.generateKey();
                    encryptedKey = cipher.doFinal(this.sessionKey.getEncoded());
                }
                catch (Exception e) {
                    throw new GSSException(13, 0, e.getMessage());
                }
            }
            ReqContents reqCont = new ReqContents(this.contextId, null, this.randomSrc, this.targetName.getX500Name(), this.isAnonymous ? null : ((GSSNameImpl)this.cred.getName()).getX500Name(), ctxData, null, keyAlgs, encryptedKey, null);
            try {
                Signature signature = Signature.getInstance("MD5withRSA");
                signature.initSign(this.cred.getVerifKey(), Random.getRandom());
                signature.update(reqCont.encode());
                reqToken = new ReqToken(reqCont, "MD5withRSA", null, signature.sign());
            }
            catch (Exception e) {
                throw new GSSException(13, 0, e.getMessage());
            }
            SpkmReq spkmReq = new SpkmReq(reqToken, certData);
            InitialContextToken token = new InitialContextToken(spkmReq);
            this.state = 1;
            try {
                token.encode(outStream);
            }
            catch (IOException e) {
                throw new GSSException(13, 0, e.getMessage());
            }
        }
        if (this.state == 1) {
            SpkmRepIT repIT;
            InitialContextToken inToken;
            try {
                inToken = new InitialContextToken(inStream);
            }
            catch (Asn1Exception e) {
                throw new GSSException(9, 0, e.getMessage());
            }
            if (inToken.getInnerContentsType() == 3) {
                this.state = 0;
                this.cred = null;
                return 0;
            }
            if (inToken.getInnerContentsType() != 1) {
                throw new GSSException(9);
            }
            SpkmRepTI repTI = inToken.getRepTI();
            RepTIToken repTIToken = repTI.getResponseToken();
            CertificationData certData = repTI.getCertifData();
            RepTIContents repTIContents = repTIToken.getRepTIContents();
            ContextData inCtxData = repTIContents.getRepData();
            if (certData != null && certData.getCertPath() != null) {
                CertificationPath certPath = certData.getCertPath();
                if (certPath.getUserCertif() != null) {
                    if (!CertUtil.IsCertTrusted((X509Certificate)certPath.getUserCertif())) {
                        throw new GSSException(13, 0, "Target certificate cannot be verified");
                    }
                    this.targKEKey = certPath.getUserCertif().getPublicKey();
                }
                if (certPath.getUserVerifCertif() != null) {
                    if (!CertUtil.IsCertTrusted((X509Certificate)certPath.getUserVerifCertif())) {
                        throw new GSSException(13, 0, "Target signature certificate cannot be verified");
                    }
                    this.targSigKey = certPath.getUserVerifCertif().getPublicKey();
                } else if (this.targKEKey != null) {
                    this.targSigKey = this.targKEKey;
                }
            }
            if (this.targKEKey == null) {
                throw new GSSException(13, 0, "Cannot obtain target public key material");
            }
            try {
                Signature signature = Signature.getInstance(repTIToken.getAlgName());
                signature.initVerify(this.targSigKey);
                signature.update(repTIContents.encode());
                if (!signature.verify(repTIToken.getRepTIInteg())) {
                    throw new GSSException(6);
                }
            }
            catch (Exception e) {
                throw new GSSException(13, 0, e.getMessage());
            }
            if (repTIContents.getPvno()[0] != 1) {
                return 0;
            }
            byte[] inRandSrc = repTIContents.getRandSrc();
            if (inRandSrc.length != this.randomSrc.length) {
                throw new GSSException(9, 0, "Received random number is not same as the sent one");
            }
            int i = 0;
            while (i < this.randomSrc.length) {
                if (inRandSrc[i] != this.randomSrc[i]) {
                    throw new GSSException(9, 0, "Received random number is not same as the sent one");
                }
                ++i;
            }
            this.contextId = repTIContents.getContextId();
            this.randomTarg = repTIContents.getRandTarg();
            if (this.ctxFlags.getSequenceState()) {
                this.seqIn = inCtxData.getSeqNumberLong();
            }
            if (this.ctxFlags.getConfState()) {
                this.confAlgs = inCtxData.getConfAlgs().getAlgs();
            }
            this.intgAlgs = inCtxData.getIntgAlgs().getAlgs();
            this.owfAlgs = inCtxData.getOWFAlgs().getAlgs();
            if (repTIContents.getKeyEstbStr() != null && this.confAlgs != null) {
                if (!repTIContents.getKeyEstbId().getOid().equals(OID.getAlgOid((String)"RSA"))) {
                    throw new GSSException(13, 0, "Invalid Key Exchange Algorithm");
                }
                try {
                    RSACipher cipher = RSACipher.getInstance();
                    cipher.init(2, (Key)this.cred.getKey(), Random.getRandom());
                    byte[] plainKey = cipher.doFinal(repTIContents.getKeyEstbStr());
                    String algName = OID.getAlgName((String)this.confAlgs[0].getOid());
                    Class<?> keySpecClass = Class.forName("javax.crypto.spec." + algName + "KeySpec");
                    Object keySpec = keySpecClass.getConstructor(plainKey.getClass()).newInstance(new Object[]{plainKey});
                    SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algName);
                    this.sessionKey = keyFact.generateSecret((KeySpec)keySpec);
                }
                catch (Exception e) {
                    throw new GSSException(13, 0, e.getMessage());
                }
            }
            if (this.ctxFlags.getConfState() && this.sessionKey == null) {
                throw new GSSException(13, 0, "No session key negotiated");
            }
            if (!this.ctxFlags.getMutualState()) {
                this.state = 2;
                GSSManagerImpl.addContext(this.contextId, this);
                return 0;
            }
            RepITToken repITToken = new RepITToken(this.contextId, this.randomSrc, this.randomTarg, this.targetName.getX500Name(), this.isAnonymous ? null : ((GSSNameImpl)this.cred.getName()).getX500Name(), null);
            try {
                Signature signature = Signature.getInstance("MD5withRSA");
                signature.initSign(this.cred.getVerifKey(), Random.getRandom());
                signature.update(repITToken.encode());
                repIT = new SpkmRepIT(repITToken, "MD5withRSA", null, signature.sign());
            }
            catch (Exception e) {
                throw new GSSException(13, 0, e.getMessage());
            }
            InitialContextToken outToken = new InitialContextToken(repIT);
            this.state = 2;
            GSSManagerImpl.addContext(this.contextId, this);
            try {
                outToken.encode(outStream);
            }
            catch (IOException e) {
                throw new GSSException(13, 0, e.getMessage());
            }
        }
        return 0;
    }

    public byte[] acceptSecContext(byte[] inTok, int offset, int len) throws GSSException {
        if (len == 0) {
            len = inTok.length;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(inTok, offset, len);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.acceptSecContext(bin, bout);
        byte[] retval = bout.toByteArray();
        return retval.length == 0 ? null : retval;
    }

    public void acceptSecContext(InputStream inStream, OutputStream outStream) throws GSSException {
        InitialContextToken inToken;
        if (this.isInitiator) {
            throw new GSSException(16);
        }
        if (this.state == 2) {
            return;
        }
        try {
            inToken = new InitialContextToken(inStream);
        }
        catch (Asn1Exception e) {
            throw new GSSException(9, 0, e.getMessage());
        }
        if (inToken.getInnerContentsType() == 3) {
            this.state = 0;
            this.cred = null;
            return;
        }
        if (this.state == 0) {
            RepTIToken repToken;
            ContextData outCtxData;
            ContextData ctxData;
            ReqContents reqContents;
            block66: {
                if (inToken.getInnerContentsType() != 0) {
                    throw new GSSException(9);
                }
                SpkmReq spkmReq = inToken.getReq();
                ReqToken reqToken = spkmReq.getRequestToken();
                reqContents = reqToken.getReqContents();
                ctxData = reqContents.getReqData();
                CertificationData certData = spkmReq.getCertifData();
                X509Certificate[] targCerts = new X509Certificate[2];
                if (certData != null && certData.getCertPath() != null) {
                    CertificationPath certPath = certData.getCertPath();
                    if (certPath.getUserCertif() != null) {
                        if (!CertUtil.IsCertTrusted((X509Certificate)certPath.getUserCertif())) {
                            throw new GSSException(13, 0, "Target certificate cannot be verified");
                        }
                        targCerts[0] = (X509Certificate)certPath.getUserCertif();
                        this.targKEKey = certPath.getUserCertif().getPublicKey();
                    }
                    if (certPath.getUserVerifCertif() != null) {
                        if (!CertUtil.IsCertTrusted((X509Certificate)certPath.getUserVerifCertif())) {
                            throw new GSSException(13, 0, "Target signature certificate cannot be verified");
                        }
                        targCerts[1] = (X509Certificate)certPath.getUserVerifCertif();
                        this.targSigKey = certPath.getUserVerifCertif().getPublicKey();
                    } else if (this.targKEKey != null) {
                        this.targSigKey = this.targKEKey;
                    }
                }
                if (this.targKEKey == null) {
                    if (reqContents.getSrcName() != null) {
                        try {
                            KeyStore keyStore = PStore.getInstance(null).getKeyStore();
                            String name = "USER_" + reqContents.getSrcName().getName();
                            String sigName = "USER_SIG_" + reqContents.getSrcName().getName();
                            if (keyStore.containsAlias(name)) {
                                Certificate[] userCerts = keyStore.getCertificateChain(name);
                                this.targKEKey = this.targSigKey = userCerts[0].getPublicKey();
                                if (keyStore.containsAlias(sigName)) {
                                    this.targSigKey = keyStore.getCertificateChain(sigName)[0].getPublicKey();
                                }
                            }
                        }
                        catch (BadPasswordException e) {
                        }
                        catch (KeyStoreException e) {
                            // empty catch block
                        }
                    }
                    if (this.targKEKey == null) {
                        throw new GSSException(13, 0, "Cannot find sender's public key information");
                    }
                }
                try {
                    Signature signature = Signature.getInstance(reqToken.getAlgName());
                    signature.initVerify(this.targSigKey);
                    signature.update(reqContents.encode());
                    if (!signature.verify(reqToken.getReqIntegrity())) {
                        throw new GSSException(6);
                    }
                }
                catch (Exception e) {
                    throw new GSSException(13, 0, e.getMessage());
                }
                if (reqContents.getPvno()[0] != 1) {
                    return;
                }
                byte[] myId = new byte[10];
                Random.getRandom().nextBytes(myId);
                this.contextId = new byte[reqContents.getContextId().length + 10];
                System.arraycopy(reqContents.getContextId(), 0, this.contextId, 0, reqContents.getContextId().length);
                System.arraycopy(myId, 0, this.contextId, reqContents.getContextId().length, 10);
                Random.getRandom().nextBytes(this.randomSrc);
                this.randomTarg = reqContents.getRandSrc();
                if (reqContents.getSrcName() != null) {
                    X500Name subjName = null;
                    boolean failed = false;
                    try {
                        subjName = new X500Name(targCerts[0].getSubjectDN().getName());
                    }
                    catch (Asn1Exception e) {
                        failed = true;
                    }
                    if (failed || !subjName.equals((Object)reqContents.getSrcName())) {
                        this.targetName = new GSSNameImpl(reqContents.getSrcName());
                        try {
                            UserStore userdb = PStore.getInstance(null).getUserStore();
                            int i = 0;
                            while (i < targCerts.length) {
                                if (UserStoreHelper.hasUser(userdb, this.targetName.getName(), targCerts[i])) {
                                    this.targetName = new GSSNameImpl(reqContents.getSrcName(), targCerts[i]);
                                    break;
                                }
                                ++i;
                            }
                            if (i == targCerts.length) {
                                throw new GSSException(2);
                            }
                            break block66;
                        }
                        catch (BadPasswordException e) {
                            throw new GSSException(13, 0, e.getMessage());
                        }
                    }
                    this.targetName = new GSSNameImpl(reqContents.getSrcName(), targCerts[0]);
                } else {
                    this.isAnonymous = true;
                }
            }
            this.ctxFlags = ctxData.getOptions();
            this.intgAlgs = Algorithms.getIntersection((AlgorithmId[])ctxData.getIntgAlgs().getAlgs(), (int)2);
            this.owfAlgs = Algorithms.getIntersection((AlgorithmId[])ctxData.getOWFAlgs().getAlgs(), (int)3);
            if (this.intgAlgs.length == 0 || this.owfAlgs.length == 0) {
                throw new GSSException(13, 0, "Cannot negotiate mandatory algorithms");
            }
            if (ctxData.getConfAlgs() != null) {
                this.confAlgs = Algorithms.getIntersection((AlgorithmId[])ctxData.getConfAlgs().getAlgs(), (int)1);
            }
            if (this.ctxFlags.getSequenceState()) {
                this.seqOut = Random.getRandom().nextLong();
                this.seqIn = ctxData.getSeqNumberLong();
                outCtxData = new ContextData(null, this.seqOut++, this.ctxFlags, this.confAlgs == null ? null : new Algs(this.confAlgs), new Algs(this.intgAlgs), new Algs(this.owfAlgs));
            } else {
                outCtxData = new ContextData(null, null, this.ctxFlags, this.confAlgs == null ? null : new Algs(this.confAlgs), new Algs(this.intgAlgs), new Algs(this.owfAlgs));
            }
            byte[] encryptedKey = null;
            if (reqContents.getKeyEstbSet().getAlgs().length == 0) {
                throw new GSSException(13, 0, "No Key Exchange algorithm specified in request token");
            }
            AlgorithmId[] keAlgs = reqContents.getKeyEstbSet().getAlgs();
            if (reqContents.getKeyEstbReq() != null && this.confAlgs != null && this.confAlgs[0].getOid().equals(ctxData.getConfAlgs().getAlgs()[0].getOid())) {
                if (OID.getAlgName((String)keAlgs[0].getOid()).equals("RSA")) {
                    try {
                        RSACipher cipher = RSACipher.getInstance();
                        cipher.init(2, (Key)this.cred.getKey(), Random.getRandom());
                        byte[] plainKey = cipher.doFinal(reqContents.getKeyEstbReq());
                        String algName = OID.getAlgName((String)this.confAlgs[0].getOid());
                        Class<?> keySpecClass = Class.forName("javax.crypto.spec." + algName + "KeySpec");
                        Object keySpec = keySpecClass.getConstructor(plainKey.getClass()).newInstance(new Object[]{plainKey});
                        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algName);
                        this.sessionKey = keyFact.generateSecret((KeySpec)keySpec);
                    }
                    catch (Exception e) {
                        throw new GSSException(13, 0, e.getMessage());
                    }
                }
            } else if (this.ctxFlags.getConfState()) {
                int i = 0;
                while (i < keAlgs.length) {
                    if (OID.getAlgName((String)keAlgs[i].getOid()).equals("RSA")) break;
                    ++i;
                }
                if (i == keAlgs.length) {
                    throw new GSSException(13, 0, "RSA Key Exchange algorithm not found in request token KeyEstbSet");
                }
                try {
                    RSACipher cipher = RSACipher.getInstance();
                    cipher.init(1, (Key)this.targKEKey, Random.getRandom());
                    String algName = OID.getAlgName((String)this.confAlgs[0].getOid());
                    KeyGenerator kg = KeyGenerator.getInstance(algName);
                    kg.init(Random.getRandom());
                    this.sessionKey = kg.generateKey();
                    encryptedKey = cipher.doFinal(this.sessionKey.getEncoded());
                }
                catch (Exception e) {
                    throw new GSSException(13, 0, e.getMessage());
                }
            }
            RepTIContents repContents = null;
            try {
                repContents = new RepTIContents(this.contextId, null, null, this.randomSrc, this.isAnonymous ? null : this.targetName.getX500Name(), ((GSSNameImpl)this.cred.getName()).getX500Name(), this.randomTarg, outCtxData, null, encryptedKey == null ? null : new AlgorithmId(OID.getAlgOid((String)"RSA")), encryptedKey);
            }
            catch (Asn1Exception e) {
                // empty catch block
            }
            try {
                Signature signature = Signature.getInstance("MD5withRSA");
                signature.initSign(this.cred.getVerifKey(), Random.getRandom());
                signature.update(repContents.encode());
                repToken = new RepTIToken(repContents, "MD5withRSA", null, signature.sign());
            }
            catch (Exception e) {
                throw new GSSException(13, 0, e.getMessage());
            }
            CertificationData outCertData = null;
            if (this.ctxFlags.getTargetCertifDataRequired()) {
                CertificationPath certPath = new CertificationPath(null, this.cred.getCertificate(), null, this.cred.getVerifCertificate(), null);
                outCertData = new CertificationData(certPath, null);
            }
            SpkmRepTI repTI = new SpkmRepTI(repToken, outCertData);
            InitialContextToken outToken = new InitialContextToken(repTI);
            this.state = 1;
            try {
                outToken.encode(outStream);
            }
            catch (IOException e) {
                throw new GSSException(13, 0, e.getMessage());
            }
        }
        if (this.state == 1) {
            if (inToken.getInnerContentsType() != 2) {
                throw new GSSException(9);
            }
            SpkmRepIT repIT = inToken.getRepIT();
            RepITToken repToken = repIT.getResponseToken();
            try {
                Signature signature = Signature.getInstance(repIT.getAlgName());
                signature.initVerify(this.targSigKey);
                signature.update(repToken.encode());
                if (!signature.verify(repIT.getRepITInteg())) {
                    throw new GSSException(6);
                }
            }
            catch (Exception e) {
                throw new GSSException(13, 0, e.getMessage());
            }
            byte[] inTargRandom = repToken.getRandTarg();
            if (inTargRandom.length != this.randomSrc.length) {
                throw new GSSException(13, 0, "Received random number differs from the sent one");
            }
            int i = 0;
            while (i < this.randomSrc.length) {
                if (inTargRandom[i] != this.randomSrc[i]) {
                    throw new GSSException(13, 0, "Received random number differs from the sent one");
                }
                ++i;
            }
            this.state = 2;
            GSSManagerImpl.addContext(this.contextId, this);
        }
    }

    public boolean isEstablished() {
        return this.state == 2;
    }

    public void dispose() throws GSSException {
        if (this.state != 0) {
            GSSManagerImpl.removeContext(this.contextId);
        }
        this.sessionKey = null;
        this.seqIn = 0L;
        this.seqOut = 0L;
        this.state = 0;
    }

    public int getWrapSizeLimit(int qop, boolean confReq, int maxTokenSize) throws GSSException {
        return -1;
    }

    public byte[] wrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        if (len == 0) {
            len = inBuf.length;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(inBuf, offset, len);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.wrap(bin, bout, msgProp);
        byte[] retval = bout.toByteArray();
        return retval.length == 0 ? null : retval;
    }

    /*
     * WARNING - void declaration
     */
    public void wrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        WrapBody wrapBody;
        String confAlgName;
        if (this.state != 2) {
            throw new GSSException(16);
        }
        byte[] buf = null;
        try {
            int count;
            byte[] tmp = new byte[1024];
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((count = inStream.read(tmp)) != -1) {
                void var5_7;
                if (var5_7 <= 0) continue;
                bout.write(tmp, 0, (int)var5_7);
            }
            buf = bout.toByteArray();
        }
        catch (IOException e) {
            throw new GSSException(13, 0, e.getMessage());
        }
        SeqNum seqNum = null;
        if (this.ctxFlags.getSequenceState()) {
            seqNum = new SeqNum(BigInteger.valueOf(this.seqOut++), !this.isInitiator);
        }
        String intgAlgName = OID.getAlgName((String)this.intgAlgs[0].getOid());
        if (this.ctxFlags.getConfState()) {
            confAlgName = OID.getAlgName((String)this.confAlgs[0].getOid());
            if (confAlgName.equals("DESede") || confAlgName.equals("DES")) {
                confAlgName = confAlgName.concat("/ECB/PKCS5Padding");
            }
        } else {
            confAlgName = null;
        }
        WrapHeader wrapHeader = new WrapHeader(this.contextId, intgAlgName, null, confAlgName, null, seqNum);
        try {
            byte[] encBuf;
            if (this.ctxFlags.getConfState()) {
                Cipher cipher = Cipher.getInstance(confAlgName);
                cipher.init(1, (Key)this.sessionKey, Random.getRandom());
                encBuf = cipher.doFinal(buf);
            } else {
                encBuf = buf;
            }
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            b.write(wrapHeader.encode());
            b.write(buf);
            byte[] toBeSigned = b.toByteArray();
            Signature sign = Signature.getInstance(intgAlgName);
            sign.initSign(this.cred.getVerifKey());
            sign.update(toBeSigned);
            wrapBody = new WrapBody(sign.sign(), encBuf);
        }
        catch (Exception e) {
            throw new GSSException(13, 0, e.getMessage());
        }
        SpkmWrap wrap = new SpkmWrap(wrapHeader, wrapBody);
        InitialContextToken token = new InitialContextToken(wrap);
        if (this.ctxFlags.getConfState()) {
            msgProp.setPrivacy(true);
        } else {
            msgProp.setPrivacy(false);
        }
        try {
            token.encode(outStream);
        }
        catch (IOException e) {
            throw new GSSException(13, 0, e.getMessage());
        }
    }

    public byte[] unwrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        if (len == 0) {
            len = inBuf.length;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(inBuf, offset, len);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.unwrap(bin, bout, msgProp);
        byte[] retval = bout.toByteArray();
        return retval.length == 0 ? null : retval;
    }

    public void unwrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        byte[] plainBuf;
        InitialContextToken token;
        if (this.state != 2) {
            throw new GSSException(16);
        }
        try {
            token = new InitialContextToken(inStream);
        }
        catch (Asn1Exception e) {
            throw new GSSException(9);
        }
        if (token.getInnerContentsType() != 5) {
            throw new GSSException(9, 0, "Invalid token type");
        }
        SpkmWrap wrap = token.getWrap();
        WrapHeader wrapHeader = wrap.getWrapHeader();
        WrapBody wrapBody = wrap.getWrapBody();
        try {
            if (this.ctxFlags.getConfState()) {
                String confAlgName = wrapHeader.getConfAlgName();
                if (confAlgName.equals("DESede") || confAlgName.equals("DES")) {
                    confAlgName = confAlgName.concat("/ECB/PKCS5Padding");
                }
                Cipher cipher = Cipher.getInstance(confAlgName);
                cipher.init(2, (Key)this.sessionKey, Random.getRandom());
                plainBuf = cipher.doFinal(wrapBody.getData());
            } else {
                plainBuf = wrapBody.getData();
            }
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            b.write(wrapHeader.encode());
            b.write(plainBuf);
            byte[] toBeSigned = b.toByteArray();
            Signature sign = Signature.getInstance(wrapHeader.getIntAlgName());
            sign.initVerify(this.targSigKey);
            sign.update(toBeSigned);
            if (!sign.verify(wrapBody.getIntCksum())) {
                throw new GSSException(6);
            }
        }
        catch (Exception e) {
            throw new GSSException(13, 0, e.getMessage());
        }
        boolean unseq = false;
        boolean gap = false;
        String reason = null;
        if (this.ctxFlags.getSequenceState()) {
            SeqNum seqNum = wrapHeader.getSndSeq();
            if (seqNum.getNumLong() < this.seqIn + 1L) {
                unseq = true;
            } else if (seqNum.getNumLong() > this.seqIn + 1L) {
                gap = true;
            } else {
                ++this.seqIn;
            }
            if (seqNum.getDirInd() != this.isInitiator) {
                unseq = true;
                reason = "Invalid direction flag";
            }
        }
        if (this.ctxFlags.getConfState()) {
            msgProp.setPrivacy(true);
        } else {
            msgProp.setPrivacy(false);
        }
        msgProp.setSupplementaryStates(false, false, unseq, gap, 0, reason);
        try {
            outStream.write(plainBuf);
        }
        catch (IOException e) {
            throw new GSSException(13, 0, e.getMessage());
        }
    }

    public byte[] getMIC(byte[] inMsg, int offset, int len, MessageProp msgProp) throws GSSException {
        if (len == 0) {
            len = inMsg.length;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(inMsg, offset, len);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.getMIC(bin, bout, msgProp);
        byte[] retval = bout.toByteArray();
        return retval.length == 0 ? null : retval;
    }

    public void getMIC(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        SpkmMic mic;
        byte[] buf;
        if (this.state != 2) {
            throw new GSSException(16);
        }
        try {
            buf = new byte[inStream.available()];
            inStream.read(buf);
        }
        catch (IOException e) {
            throw new GSSException(13, 0, e.getMessage());
        }
        SeqNum seqNum = null;
        if (this.ctxFlags.getSequenceState()) {
            seqNum = new SeqNum(BigInteger.valueOf(this.seqOut++), !this.isInitiator);
        }
        try {
            String algName = OID.getAlgName((String)this.intgAlgs[0].getOid());
            Signature sign = Signature.getInstance(algName);
            sign.initSign(this.cred.getVerifKey(), Random.getRandom());
            sign.update(buf);
            MicHeader micHeader = new MicHeader(this.contextId, algName, null, seqNum);
            mic = new SpkmMic(micHeader, sign.sign());
        }
        catch (Exception e) {
            throw new GSSException(13, 0, e.getMessage());
        }
        msgProp.setPrivacy(false);
        try {
            mic.encode(outStream);
        }
        catch (IOException e) {
            throw new GSSException(13, 0, e.getMessage());
        }
    }

    public void verifyMIC(byte[] inTok, int tokOffset, int tokLen, byte[] inMsg, int msgOffset, int msgLen, MessageProp msgProp) throws GSSException {
        if (tokLen == 0) {
            tokLen = inTok.length;
        }
        if (msgLen == 0) {
            msgLen = inMsg.length;
        }
        ByteArrayInputStream tokIn = new ByteArrayInputStream(inTok, tokOffset, tokLen);
        ByteArrayInputStream msgIn = new ByteArrayInputStream(inMsg, msgOffset, msgLen);
        this.verifyMIC(tokIn, msgIn, msgProp);
    }

    public void verifyMIC(InputStream tokStream, InputStream msgStream, MessageProp msgProp) throws GSSException {
        InitialContextToken token;
        byte[] msgBuf;
        if (this.state != 2) {
            throw new GSSException(16);
        }
        try {
            msgBuf = new byte[msgStream.available()];
            msgStream.read(msgBuf);
        }
        catch (IOException e) {
            throw new GSSException(13, 0, e.getMessage());
        }
        try {
            token = new InitialContextToken(tokStream);
        }
        catch (Asn1Exception e) {
            throw new GSSException(9, 0, e.getMessage());
        }
        if (token.getInnerContentsType() != 4) {
            throw new GSSException(9, 0, "Invalid token type");
        }
        SpkmMic mic = token.getMic();
        MicHeader micHeader = mic.getMicHeader();
        try {
            Signature sign = Signature.getInstance(micHeader.getAlgName());
            sign.initVerify(this.targSigKey);
            sign.update(msgBuf);
            if (!sign.verify(mic.getIntCksum())) {
                throw new GSSException(6);
            }
        }
        catch (Exception e) {
            throw new GSSException(13, 0, e.getMessage());
        }
        boolean unseq = false;
        boolean gap = false;
        String reason = null;
        if (this.ctxFlags.getSequenceState()) {
            SeqNum seqNum = micHeader.getSndSeq();
            if (seqNum.getNumLong() < this.seqIn + 1L) {
                unseq = true;
            } else if (seqNum.getNumLong() > this.seqIn + 1L) {
                gap = true;
            } else {
                ++this.seqIn;
            }
            if (seqNum.getDirInd() != this.isInitiator) {
                unseq = true;
                reason = "Invalid direction flag";
            }
        }
        msgProp.setPrivacy(false);
        msgProp.setSupplementaryStates(false, false, unseq, gap, 0, reason);
    }

    public byte[] export() throws GSSException {
        throw new GSSException(16);
    }

    public void requestMutualAuth(boolean state) throws GSSException {
        this.ctxFlags.setMutualState(state);
    }

    public void requestReplayDet(boolean state) throws GSSException {
        throw new GSSException(16);
    }

    public void requestSequenceDet(boolean state) throws GSSException {
        this.ctxFlags.setSequenceState(state);
    }

    public void requestCredDeleg(boolean state) throws GSSException {
        throw new GSSException(16);
    }

    public void requestAnonymity(boolean state) throws GSSException {
        this.isAnonymous = state;
    }

    public void requestConf(boolean state) throws GSSException {
        this.ctxFlags.setConfState(state);
    }

    public void requestInteg(boolean state) throws GSSException {
        this.ctxFlags.setIntegState(state);
    }

    public void requestLifetime(int lifetime) throws GSSException {
        throw new UnsupportedOperationException("Method requestLifetime() not yet implemented.");
    }

    public void setChannelBinding(ChannelBinding cb) throws GSSException {
        throw new GSSException(16);
    }

    public boolean getCredDelegState() {
        return this.ctxFlags.getDelegationState();
    }

    public boolean getMutualAuthState() {
        return this.ctxFlags.getMutualState();
    }

    public boolean getReplayDetState() {
        return this.ctxFlags.getReplayDetState();
    }

    public boolean getSequenceDetState() {
        return this.ctxFlags.getSequenceState();
    }

    public boolean getAnonymityState() {
        return this.isAnonymous;
    }

    public boolean isTransferable() throws GSSException {
        return false;
    }

    public boolean isProtReady() {
        return this.state == 2;
    }

    public boolean getConfState() {
        return this.ctxFlags.getConfState();
    }

    public boolean getIntegState() {
        return this.ctxFlags.getIntegState();
    }

    public int getLifetime() {
        throw new UnsupportedOperationException("Method getLifetime() not yet implemented.");
    }

    public GSSName getSrcName() throws GSSException {
        return this.cred.getName();
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return GSSManagerImpl.Spkm_1;
    }

    public GSSCredential getDelegCred() throws GSSException {
        throw new GSSException(16);
    }

    public boolean isInitiator() throws GSSException {
        return this.isInitiator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

