/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Sequence;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ErrorToken
extends Sequence {
    private int tokId = 1024;
    private byte[] contextId;

    public ErrorToken(byte[] contextId, boolean dummy) {
        this.addComponent((Asn1)new Integer(this.tokId));
        this.contextId = contextId;
        this.addComponent((Asn1)new BitString(this.contextId));
    }

    public ErrorToken(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public ErrorToken(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.tokId = ((Integer)((Constructed)this).components.get(0)).getInt();
        if (this.tokId != 1024) {
            throw new Asn1Exception("Invalid token id");
        }
        this.contextId = ((BitString)((Constructed)this).components.get(1)).getBytes();
    }

    public byte[] getContextId() {
        return this.contextId;
    }
}

