/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Asn1String;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Primitive;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.x509.Asn1Cert;
import com.idoox.security.x509.CertificatePair;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class CertificationPath
extends Sequence {
    private byte[] userKeyId;
    private Certificate userCertif;
    private byte[] verifKeyId;
    private Certificate userVerifCertif;
    private CertificatePair[] caCertificates;

    public CertificationPath(byte[] userKeyId, Certificate userCertif, byte[] verifyKeyId, Certificate userVerifCertif, CertificatePair[] caCertificates) {
        Implicit imp;
        this.userKeyId = userKeyId;
        if (userKeyId != null) {
            imp = new Implicit(-128, 0);
            imp.addComponent((Asn1)new Asn1String(this.userKeyId));
            this.addComponent((Asn1)imp);
        }
        this.userCertif = userCertif;
        if (userCertif != null) {
            imp = new Implicit(-128, 1);
            imp.addComponent((Asn1)new Asn1Cert(this.userCertif));
            this.addComponent((Asn1)imp);
        }
        this.verifKeyId = this.verifKeyId;
        if (this.verifKeyId != null) {
            imp = new Implicit(-128, 2);
            imp.addComponent((Asn1)new Asn1String(this.verifKeyId));
            this.addComponent((Asn1)imp);
        }
        this.userVerifCertif = userVerifCertif;
        if (userVerifCertif != null) {
            imp = new Implicit(-128, 3);
            imp.addComponent((Asn1)new Asn1Cert(this.userVerifCertif));
            this.addComponent((Asn1)imp);
        }
        this.caCertificates = caCertificates;
        if (caCertificates != null && caCertificates.length > 0) {
            imp = new Implicit(-128, 4);
            Sequence seq = new Sequence();
            int i = 0;
            while (i < caCertificates.length) {
                seq.addComponent((Asn1)this.caCertificates[i]);
                ++i;
            }
            imp.addComponent((Asn1)seq);
            this.addComponent((Asn1)imp);
        }
    }

    public CertificationPath(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public CertificationPath(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        block12: {
            int i = 0;
            this.doDecode(encoded);
            try {
                ByteArrayInputStream bi;
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                Asn1 comp = (Asn1)((Constructed)this).components.get(i);
                if (comp.getTagNumber() == 0) {
                    this.userKeyId = ((Primitive)comp).getBytes();
                    if (++i == ((Constructed)this).components.size()) {
                        return;
                    }
                }
                if ((comp = (Asn1)((Constructed)this).components.get(i)).getTagNumber() == 1) {
                    bi = new ByteArrayInputStream(comp.encode());
                    this.userCertif = cf.generateCertificate(bi);
                    if (++i == ((Constructed)this).components.size()) {
                        return;
                    }
                }
                if ((comp = (Asn1)((Constructed)this).components.get(i)).getTagNumber() == 2) {
                    this.verifKeyId = ((Primitive)comp).getBytes();
                    if (++i == ((Constructed)this).components.size()) {
                        return;
                    }
                }
                if ((comp = (Asn1)((Constructed)this).components.get(i)).getTagNumber() == 3) {
                    bi = new ByteArrayInputStream(comp.encode());
                    this.userVerifCertif = cf.generateCertificate(bi);
                    if (++i == ((Constructed)this).components.size()) {
                        return;
                    }
                }
                if ((comp = (Asn1)((Constructed)this).components.get(i)).getTagNumber() == 4) {
                    ArrayList con = ((Constructed)comp).getComponents();
                    this.caCertificates = new CertificatePair[con.size()];
                    int j = 0;
                    Iterator it = ((AbstractList)con).iterator();
                    while (it.hasNext()) {
                        this.caCertificates[j] = new CertificatePair(((Asn1)it.next()).encode());
                        ++j;
                    }
                    break block12;
                }
                throw new Asn1Exception("Invalid tag number");
            }
            catch (CertificateException e) {
                throw new Asn1Exception(e.getMessage());
            }
        }
    }

    public byte[] getUserKeyId() {
        return this.userKeyId;
    }

    public Certificate getUserCertif() {
        return this.userCertif;
    }

    public byte[] getVerifKeyId() {
        return this.verifKeyId;
    }

    public Certificate getUserVerifCertif() {
        return this.userVerifCertif;
    }

    public CertificatePair[] getCACertificates() {
        return this.caCertificates;
    }
}

