/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.CertificationPath;
import com.idoox.security.x509.Asn1CRL;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;

public class CertificationData
extends Sequence {
    private CertificationPath certPath;
    private X509CRL crl;

    public CertificationData(CertificationPath certPath, X509CRL crl) {
        Implicit imp;
        this.certPath = certPath;
        this.crl = crl;
        if (this.certPath != null) {
            imp = new Implicit(-128, 0);
            imp.addComponent((Asn1)this.certPath);
            this.addComponent((Asn1)imp);
        }
        if (this.crl != null) {
            imp = new Implicit(-128, 1);
            imp.addComponent((Asn1)new Asn1CRL(this.crl));
            this.addComponent((Asn1)imp);
        }
    }

    public CertificationData(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public CertificationData(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        int i = 0;
        this.doDecode(encoded);
        Constructed cons = (Constructed)((Constructed)this).components.get(i);
        if (cons.getTagNumber() == 0) {
            this.certPath = new CertificationPath(cons.encode());
            ++i;
        }
        if (i == ((Constructed)this).components.size()) {
            return;
        }
        cons = (Constructed)((Constructed)this).components.get(i);
        if (cons.getTagNumber() == 1) {
            ByteArrayInputStream bi = new ByteArrayInputStream(cons.encode());
            try {
                this.crl = (X509CRL)CertificateFactory.getInstance("X509").generateCRL(bi);
            }
            catch (CertificateException e) {
                throw new Asn1Exception(e.getMessage());
            }
            catch (CRLException e) {
                throw new Asn1Exception(e.getMessage());
            }
        } else {
            throw new Asn1Exception("Invalid tag number");
        }
    }

    public CertificationPath getCertPath() {
        return this.certPath;
    }

    public X509CRL getCRL() {
        return this.crl;
    }
}

