/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore.ldap;

import com.idoox.debug.Category;
import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.security.pstore.ldap.LdapUserStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.idoox.security.pstore.PStore;
import org.idoox.security.util.RuntimeWrappedException;

public class ActiveDirectoryUserStore
extends LdapUserStore {
    static Category log = Category.getCategory((class$com$idoox$security$pstore$ldap$ActiveDirectoryUserStore == null ? (class$com$idoox$security$pstore$ldap$ActiveDirectoryUserStore = ActiveDirectoryUserStore.class$("com.idoox.security.pstore.ldap.ActiveDirectoryUserStore")) : class$com$idoox$security$pstore$ldap$ActiveDirectoryUserStore).getName());
    public static final String AUTH_CACHE_EXPIRATION_KEY = "wasp.ldap.auth.cache.expiration";
    public static final String GSS_LOGIN_MODULE_KEY = "wasp.ldap.jaas.loginmodule";
    private Map authMap = new Hashtable();
    protected long AUTH_CACHE_EXPIRATION = 300000L;
    protected LdapContext userDirContext = null;
    protected String loginModuleName = null;
    private Timer timer = null;
    static /* synthetic */ Class class$com$idoox$security$pstore$ldap$ActiveDirectoryUserStore;

    private void internalInitialize() {
        log.info("init()");
        String tmp = this.props.getProperty(AUTH_CACHE_EXPIRATION_KEY);
        if (tmp != null) {
            this.AUTH_CACHE_EXPIRATION = Long.parseLong(tmp);
        }
        this.loginModuleName = this.props.getProperty(GSS_LOGIN_MODULE_KEY);
        if (this.AUTH_CACHE_EXPIRATION > 0L) {
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.timer.schedule((TimerTask)new Cleaner(), this.AUTH_CACHE_EXPIRATION, this.AUTH_CACHE_EXPIRATION);
        }
    }

    public ActiveDirectoryUserStore() throws Exception {
        this.internalInitialize();
    }

    public ActiveDirectoryUserStore(String password) throws Exception {
        super(password);
        this.internalInitialize();
    }

    public ActiveDirectoryUserStore(Properties properties) throws Exception {
        super(properties);
        this.internalInitialize();
    }

    protected boolean isAttributeMatch(Attributes attrs, Map filter) throws NamingException {
        if (filter == null) {
            return true;
        }
        Iterator requested = filter.entrySet().iterator();
        while (requested.hasNext()) {
            Map.Entry entry = requested.next();
            Attribute attr = attrs.get(this.wasp2LdapKey(entry.getKey()));
            if (entry.getKey().equals("password")) {
                String principleName = attrs.get(this.USER_ID).get().toString();
                byte[] cachedCreds = null;
                CredentialEntry credentialEntry = (CredentialEntry)this.authMap.get(principleName);
                if (credentialEntry != null && System.currentTimeMillis() - credentialEntry.getInsertTime() > this.AUTH_CACHE_EXPIRATION) {
                    this.authMap.remove(principleName);
                } else if (credentialEntry != null) {
                    cachedCreds = (byte[])credentialEntry.getCredentials();
                }
                byte[] creds = filter.get("password").toString().getBytes();
                MessageDigest md = null;
                try {
                    md = MessageDigest.getInstance("SHA1");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeWrappedException((Throwable)e);
                }
                md.update(creds);
                byte[] hash = md.digest();
                md.reset();
                if (cachedCreds == null) {
                    try {
                        ActiveDirectoryUserStore activeDirectoryUserStore;
                        String simplePrincipleName = attrs.get("userPrincipalName").get().toString();
                        if (this.userDirContext == null) {
                            activeDirectoryUserStore = this;
                            synchronized (activeDirectoryUserStore) {
                                this.userDirContext = new InitialLdapContext(this.props, null);
                            }
                        }
                        if (this.loginModuleName == null) {
                            activeDirectoryUserStore = this;
                            synchronized (activeDirectoryUserStore) {
                                this.userDirContext.addToEnvironment("java.naming.security.principal", simplePrincipleName);
                                this.userDirContext.addToEnvironment("java.naming.security.credentials", creds);
                                try {
                                    this.userDirContext.reconnect(null);
                                }
                                catch (NamingException ce) {
                                    log.debug("CommucationException inside LDAP authentication  ... reconnecting");
                                    this.userDirContext.close();
                                    this.userDirContext = new InitialLdapContext(this.props, null);
                                    this.userDirContext.addToEnvironment("java.naming.security.principal", simplePrincipleName);
                                    this.userDirContext.addToEnvironment("java.naming.security.credentials", creds);
                                    this.userDirContext.reconnect(null);
                                }
                            }
                        }
                        activeDirectoryUserStore = this;
                        synchronized (activeDirectoryUserStore) {
                            this.checkItUsingJass(principleName, creds);
                        }
                        this.authMap.put(principleName, new CredentialEntry(hash, System.currentTimeMillis()));
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("Error while creating JNDI DirContext for principal authentication", e);
                        return false;
                    }
                }
                if (ActiveDirectoryUserStore.comparePassword(cachedCreds, hash)) continue;
                return false;
            }
            if (attr == null || attr.size() == 0) {
                return false;
            }
            if (entry.getValue() == null) continue;
            Object value = attr.get();
            if (value instanceof byte[]) {
                value = this.deserialize(entry.getKey().toString(), value);
            }
            if (value instanceof Object[]) {
                if (!(entry.getValue() instanceof Object[])) {
                    return false;
                }
                Object[] myAr = (Object[])value;
                Object[] given = (Object[])entry.getValue();
                if (given.length != myAr.length) {
                    return false;
                }
                int i = 0;
                while (i < myAr.length) {
                    if (given[i] != null && myAr[i] != null) {
                        if (!myAr[i].equals(given[i])) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            if (value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private void checkItUsingJass(String name, byte[] password) throws Exception {
        LoginContext lc = new LoginContext(this.loginModuleName, new WaspCallbackHandler(name, new String(password, "UTF-8"), "", PStore.getInstance("").getKeyStore(), PStore.getInstance("").getUserStore()));
        lc.login();
        Subject.doAsPrivileged(lc.getSubject(), new GSSLoginAction(name, password), null);
    }

    private static boolean comparePassword(byte[] pass1, byte[] pass2) {
        if (pass1.length != pass2.length) {
            return false;
        }
        int i = 0;
        while (i < pass1.length) {
            if (pass1[i] != pass2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void destroy() {
        this.timer.cancel();
        try {
            if (this.userDirContext != null) {
                this.userDirContext.close();
            }
        }
        catch (NamingException e) {
            log.error("Exception while destroying LDAP context.", e);
        }
        super.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class CredentialEntry {
        long insertTime;
        Object credentials;

        public CredentialEntry(Object credentials, long insertTime) {
            this.insertTime = insertTime;
            this.credentials = credentials;
        }

        public long getInsertTime() {
            return this.insertTime;
        }

        public void setInsertTime(long insertTime) {
            this.insertTime = insertTime;
        }

        public Object getCredentials() {
            return this.credentials;
        }

        public void setCredentials(Object credentials) {
            this.credentials = credentials;
        }
    }

    private class GSSLoginAction
    implements PrivilegedExceptionAction {
        String name;
        byte[] pass;

        public GSSLoginAction(String name, byte[] pass) {
            this.name = name;
            this.pass = pass;
        }

        public Object run() throws Exception {
            ActiveDirectoryUserStore.this.userDirContext.addToEnvironment("java.naming.security.authentication", "GSSAPI");
            try {
                ActiveDirectoryUserStore.this.userDirContext.reconnect(null);
            }
            catch (Exception e) {
                if (e instanceof NamingException) {
                    log.debug("CommunicationException inside ActiveDirectory authentication  ... reconnecting");
                    ActiveDirectoryUserStore.this.userDirContext.close();
                    ActiveDirectoryUserStore.this.userDirContext = new InitialLdapContext(ActiveDirectoryUserStore.this.props, null);
                    ActiveDirectoryUserStore.this.userDirContext.addToEnvironment("java.naming.security.principal", this.name);
                    ActiveDirectoryUserStore.this.userDirContext.addToEnvironment("java.naming.security.credentials", this.pass);
                    ActiveDirectoryUserStore.this.userDirContext.addToEnvironment("java.naming.security.authentication", "GSSAPI");
                    ActiveDirectoryUserStore.this.userDirContext.reconnect(null);
                }
                throw e;
            }
            return null;
        }
    }

    private class Cleaner
    extends TimerTask {
        private Cleaner() {
        }

        public void run() {
            Iterator it = ActiveDirectoryUserStore.this.authMap.entrySet().iterator();
            long currentTime = System.currentTimeMillis();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                CredentialEntry data = (CredentialEntry)entry.getValue();
                if (data.getInsertTime() + ActiveDirectoryUserStore.this.AUTH_CACHE_EXPIRATION <= currentTime) continue;
                it.remove();
            }
        }
    }
}

