/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore.ext;

import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.util.OID;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import org.idoox.security.pstore.PropertySerializer;
import org.idoox.security.util.RuntimeWrappedException;

public class PKCS8KeyPropertySerializer
implements PropertySerializer {
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$java$security$PrivateKey;

    public byte[] encode(Object property) {
        if (!(property instanceof Key)) {
            throw new RuntimeWrappedException("Encoding failure, key :" + property);
        }
        Key key = (Key)property;
        try {
            KeyFactory kf = KeyFactory.getInstance(key.getAlgorithm());
            PKCS8EncodedKeySpec toReturn = (PKCS8EncodedKeySpec)kf.getKeySpec(key, class$java$security$spec$PKCS8EncodedKeySpec == null ? (class$java$security$spec$PKCS8EncodedKeySpec = PKCS8KeyPropertySerializer.class$("java.security.spec.PKCS8EncodedKeySpec")) : class$java$security$spec$PKCS8EncodedKeySpec);
            return toReturn.getEncoded();
        }
        catch (Exception exception) {
            throw new RuntimeWrappedException("Encoding failure, key :" + property, (Throwable)exception);
        }
    }

    public Object decode(byte[] encoded) {
        try {
            KeyFactory kf = KeyFactory.getInstance(PKCS8KeyPropertySerializer.getAlgorithm(encoded));
            return kf.generatePrivate(new PKCS8EncodedKeySpec(encoded));
        }
        catch (Exception exception) {
            throw new RuntimeWrappedException("Encoding failure, cannot determine type of key", (Throwable)exception);
        }
    }

    private static String getAlgorithm(byte[] encoded) throws Asn1Exception {
        int stop;
        if ((encoded[0] & 0x3F) != 48) {
            throw new Asn1Exception("PrivateKeyInfo Sequence Expected");
        }
        int i = 2;
        if ((encoded[1] & 0x80) == 128) {
            i += encoded[1] & 0x7F;
        }
        if (encoded[i] != 2) {
            throw new Asn1Exception("Version field Expected");
        }
        if ((encoded[++i] & 0x80) == 128) {
            stop = encoded[i] ^ 128 + i;
            int j = ++i;
            while (j <= stop) {
                i <<= encoded[j];
                ++j;
            }
        } else {
            i += 2;
        }
        if ((encoded[i] & 0x3F) != 48) {
            throw new Asn1Exception("PrivateKeyAlgorithmIdentifier Sequence Expected");
        }
        if ((encoded[++i] & 0x80) == 128) {
            i += encoded[1] & 0x7F;
        }
        if (encoded[++i] != 6) {
            throw new Asn1Exception("OID Primitive type was expected");
        }
        stop = encoded[++i] + i;
        StringBuffer retval = new StringBuffer();
        retval.append(encoded[++i] / 40);
        retval.append("." + encoded[i] % 40);
        int next = 0;
        int j = ++i;
        while (j <= stop) {
            if ((encoded[j] & 0x80) == 0) {
                next = next << 7 | encoded[j];
                retval.append(".");
                retval.append(next);
                next = 0;
            } else {
                next = next << 7 | encoded[j] & 0x7F;
            }
            ++j;
        }
        String oid = retval.toString();
        String algorithm = OID.getAlgName((String)oid);
        if (algorithm == null) {
            throw new Asn1Exception("Algorithm is not known for OID: " + oid);
        }
        return algorithm;
    }

    public Class getAcceptingClass() {
        return class$java$security$PrivateKey == null ? (class$java$security$PrivateKey = PKCS8KeyPropertySerializer.class$("java.security.PrivateKey")) : class$java$security$PrivateKey;
    }

    public String getPropertyDescription() {
        return "PKCS8 Serializer without support for encrypted content";
    }

    public String getType() {
        return "application/pkcs8";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

