/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.idoox.security.pstore.PropertySerializer;
import org.idoox.security.util.RuntimeWrappedException;

public class X509certchainPropertySerializer
implements PropertySerializer {
    static /* synthetic */ Class array$Ljava$security$cert$X509Certificate;

    public byte[] encode(Object property) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            X509Certificate[] toSerialize = null;
            if (!(property instanceof X509Certificate[])) {
                int len = ((Object[])property).length;
                toSerialize = new X509Certificate[len];
                int i = 0;
                while (i < len) {
                    toSerialize[i] = (X509Certificate)((Object[])property)[i];
                    ++i;
                }
            } else {
                toSerialize = (X509Certificate[])property;
            }
            int i = 0;
            while (i < toSerialize.length) {
                bos.write(toSerialize[i].getEncoded());
                ++i;
            }
            bos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Exception during encoding of certificate chain", (Throwable)e);
        }
    }

    public Object decode(byte[] encoded) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(encoded);
            X509Certificate[] toReturn = new X509Certificate[1];
            int certs = 0;
            while (bais.available() > 0) {
                X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                if (toReturn.length == certs) {
                    X509Certificate[] newToReturn = new X509Certificate[certs * 2];
                    System.arraycopy(toReturn, 0, newToReturn, 0, certs);
                    toReturn = newToReturn;
                }
                toReturn[certs] = cert;
                ++certs;
            }
            bais.close();
            if (toReturn.length != certs) {
                X509Certificate[] newToReturn = new X509Certificate[certs];
                System.arraycopy(toReturn, 0, newToReturn, 0, certs);
                toReturn = newToReturn;
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Exception during decoding of certificate chain", (Throwable)e);
        }
    }

    public String getPropertyDescription() {
        return "X509 Certificate chain";
    }

    public Class getAcceptingClass() {
        return array$Ljava$security$cert$X509Certificate == null ? (array$Ljava$security$cert$X509Certificate = X509certchainPropertySerializer.class$("[Ljava.security.cert.X509Certificate;")) : array$Ljava$security$cert$X509Certificate;
    }

    public String getType() {
        return "application/x-x509-ca-cert";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

